/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef.describers;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;
import org.eclipse.rcptt.tesla.ui.describers.WidgetDescriber;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class FigureDescriber
implements IWidgetDescriber {
    private final IFigure figure;
    private final GraphicalViewer viewer;
    private final EditPart editPart;

    public FigureDescriber(IFigure figure, EditPart editPart, GraphicalViewer viewer) {
        this.figure = figure;
        this.editPart = editPart;
        this.viewer = viewer;
    }

    public Rectangle getBounds() {
        org.eclipse.draw2d.geometry.Rectangle bounds = this.figure.getBounds().getCopy();
        this.figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Display getDisplay() {
        return this.getWidget().getDisplay();
    }

    public Point getPoint() {
        org.eclipse.draw2d.geometry.Rectangle bounds = this.figure.getBounds().getCopy();
        this.figure.translateToAbsolute((Translatable)bounds);
        IFigure parent = this.figure.getParent();
        org.eclipse.draw2d.geometry.Rectangle pbounds = parent.getBounds().getCopy();
        parent.translateToAbsolute((Translatable)pbounds);
        if (bounds.x < pbounds.x && bounds.y < pbounds.y) {
            bounds = pbounds;
        }
        return this.getDisplay().map((Control)this.getWidget(), null, bounds.x, bounds.y);
    }

    public Point getRealPoint() {
        return this.getPoint();
    }

    public Widget getWidget() {
        return this.viewer.getControl();
    }

    public Widget getItemWidget() {
        return null;
    }

    public void redraw() {
    }

    public IWidgetDescriber getControl() {
        return new WidgetDescriber((Widget)this.viewer.getControl());
    }

    public EditPart getEditPart() {
        return this.editPart;
    }

    public IFigure getFigure() {
        return this.figure;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.editPart == null ? 0 : this.editPart.hashCode());
        result = 31 * result + (this.figure == null ? 0 : this.figure.hashCode());
        result = 31 * result + (this.viewer == null ? 0 : this.viewer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FigureDescriber other = (FigureDescriber)obj;
        if (this.editPart == null ? other.editPart != null : !this.editPart.equals(other.editPart)) {
            return false;
        }
        if (this.figure == null ? other.figure != null : !this.figure.equals(other.figure)) {
            return false;
        }
        return !(this.viewer == null ? other.viewer != null : !this.viewer.equals(other.viewer));
    }

    public Image captureImage() {
        Widget widget = this.getControl().getWidget();
        Rectangle bounds = this.getBounds();
        if (widget instanceof Control) {
            return SWTUIPlayer.captureControlImageRaw((Control)((Control)widget), (Rectangle)bounds);
        }
        return null;
    }

    public boolean supportsDND() {
        return true;
    }
}

