/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.egit.ui.internal.merge.MergeResultDialog;
import org.eclipse.egit.ui.internal.rebase.RebaseResultDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PullResultDialog
extends Dialog {
    private final Repository repo;
    private final PullResult result;
    private boolean persistSize;

    public PullResultDialog(Shell shell, Repository repo, PullResult result) {
        super(shell);
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF | 0x4F0);
        this.setBlockOnOpen(false);
        this.repo = repo;
        this.result = result;
        this.persistSize = this.hasFetchResults() || this.hasMergeResults();
    }

    private boolean hasFetchResults() {
        FetchResult fetchResult = this.result.getFetchResult();
        return fetchResult != null && !fetchResult.getTrackingRefUpdates().isEmpty();
    }

    private boolean hasMergeResults() {
        MergeResult mergeResult = this.result.getMergeResult();
        return mergeResult != null && mergeResult.getMergeStatus() != MergeResult.MergeStatus.ALREADY_UP_TO_DATE;
    }

    private boolean hasRebaseResults() {
        RebaseResult rebaseResult = this.result.getRebaseResult();
        return rebaseResult != null && rebaseResult.getStatus() != RebaseResult.Status.UP_TO_DATE;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(main);
        GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
        Group fetchResultGroup = new Group(main, 16);
        fetchResultGroup.setText(UIText.PullResultDialog_FetchResultGroupHeader);
        GridLayoutFactory.fillDefaults().applyTo((Composite)fetchResultGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fetchResultGroup);
        FetchResult fRes = this.result.getFetchResult();
        if (this.hasFetchResults()) {
            GridLayoutFactory.fillDefaults().applyTo((Composite)fetchResultGroup);
            FetchResultDialog dlg = new FetchResultDialog(this.getParentShell(), this.repo, fRes, this.result.getFetchedFrom());
            Control fresult = dlg.createFetchResultTable((Composite)fetchResultGroup);
            Object layoutData = fresult.getLayoutData();
            if (layoutData instanceof GridData) {
                GridDataFactory.createFrom((GridData)((GridData)layoutData)).hint(-1, 130).applyTo(fresult);
            }
        } else {
            GridLayoutFactory.swtDefaults().applyTo((Composite)fetchResultGroup);
            Label noResult = new Label((Composite)fetchResultGroup, 0);
            if (this.result.getFetchedFrom().equals(".")) {
                noResult.setText(UIText.PullResultDialog_NothingToFetchFromLocal);
            } else {
                noResult.setText(NLS.bind((String)UIText.FetchResultDialog_labelEmptyResult, (Object)this.result.getFetchedFrom()));
            }
        }
        Group mergeResultGroup = new Group(main, 16);
        mergeResultGroup.setText(UIText.PullResultDialog_MergeResultGroupHeader);
        if (this.hasMergeResults()) {
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mergeResultGroup);
            GridLayoutFactory.fillDefaults().applyTo((Composite)mergeResultGroup);
            MergeResultDialog dlg = new MergeResultDialog(this.getParentShell(), this.repo, this.result.getMergeResult());
            dlg.createDialogArea((Composite)mergeResultGroup);
        } else if (this.hasRebaseResults()) {
            RebaseResultDialog.createFailedOrConflictsParts((Composite)mergeResultGroup, this.result.getRebaseResult());
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mergeResultGroup);
        } else {
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)mergeResultGroup);
            GridLayoutFactory.swtDefaults().applyTo((Composite)mergeResultGroup);
            Label noResult = new Label((Composite)mergeResultGroup, 0);
            noResult.setText(UIText.PullResultDialog_MergeAlreadyUpToDateMessage);
        }
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)UIText.PullResultDialog_DialogTitle, (Object)Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repo)));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogBoundSettings(((Object)((Object)this)).getClass());
    }

    protected int getDialogBoundsStrategy() {
        int strategy = 1;
        if (this.persistSize) {
            strategy |= 2;
        }
        return strategy;
    }

    protected Point getInitialSize() {
        if (!this.persistSize) {
            Point size = super.getInitialSize();
            size.x = this.getPersistedSize().x;
            return size;
        }
        return super.getInitialSize();
    }

    private Point getPersistedSize() {
        boolean oldPersistSize = this.persistSize;
        this.persistSize = true;
        try {
            Point persistedSize;
            Point point = persistedSize = super.getInitialSize();
            return point;
        }
        finally {
            this.persistSize = oldPersistSize;
        }
    }
}

