/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class ImportChangedProjectsCommand
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        HashSet<File> changedFiles = new HashSet<File>();
        List<RevCommit> commits = this.getSelectedCommits(event);
        for (RevCommit commit : commits) {
            RepositoryCommit repoCommit = new RepositoryCommit(repository, commit);
            changedFiles.addAll(this.determineChangedFilesOfCommit(repoCommit));
        }
        Set<File> dotProjectFiles = this.findDotProjectFiles(changedFiles, repository);
        this.importProjects(dotProjectFiles);
        return null;
    }

    private Set<File> determineChangedFilesOfCommit(RepositoryCommit repoCommit) {
        FileDiff[] fileDiffs;
        HashSet<File> changedFilesOfCommit = new HashSet<File>();
        File rootOfWorkingDirectory = repoCommit.getRepository().getWorkTree();
        FileDiff[] fileDiffArray = fileDiffs = repoCommit.getDiffs();
        int n = fileDiffs.length;
        int n2 = 0;
        while (n2 < n) {
            FileDiff fileDiff = fileDiffArray[n2];
            this.addIfNotDevNull(changedFilesOfCommit, rootOfWorkingDirectory, fileDiff.getNewPath());
            this.addIfNotDevNull(changedFilesOfCommit, rootOfWorkingDirectory, fileDiff.getOldPath());
            ++n2;
        }
        return changedFilesOfCommit;
    }

    private void addIfNotDevNull(Set<File> changedFilesOfCommit, File rootOfWorkingDirectory, String relativePathOfChangedFile) {
        if (!relativePathOfChangedFile.contains("/dev/null")) {
            changedFilesOfCommit.add(new File(rootOfWorkingDirectory, relativePathOfChangedFile));
        }
    }

    private Set<File> findDotProjectFiles(Set<File> changedFiles, Repository repository) {
        HashSet<File> result = new HashSet<File>();
        String workingTreeRootPath = repository.getWorkTree().toString();
        for (File changedFile : changedFiles) {
            File projectFile = this.searchEnclosingProjectInWorkDir(changedFile.getParentFile().getAbsoluteFile(), workingTreeRootPath);
            if (projectFile == null) continue;
            result.add(projectFile);
        }
        return result;
    }

    private File searchEnclosingProjectInWorkDir(File startFolder, String workingTreeRootPath) {
        File projectFile = null;
        File currentPath = startFolder;
        while (currentPath.toString().startsWith(workingTreeRootPath)) {
            projectFile = new File(String.valueOf(currentPath.toString()) + File.separator + ".project");
            if (projectFile.isFile()) break;
            projectFile = null;
            currentPath = currentPath.getParentFile();
        }
        return projectFile;
    }

    private void importProjects(final Set<File> dotProjectFiles) {
        WorkspaceJob job = new WorkspaceJob(UIText.ImportChangedProjectsCommand_ImportingChangedProjects){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)dotProjectFiles.size());
                for (File f : dotProjectFiles) {
                    if (progress.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    String ap = f.getAbsolutePath();
                    ImportChangedProjectsCommand.this.importProject(ap, (IProgressMonitor)progress.newChild(1));
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void importProject(String path, IProgressMonitor monitor) {
        try {
            IProjectDescription description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)new Path(path));
            if (description != null) {
                String projectName = description.getName();
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project.exists()) {
                    if (!project.isOpen()) {
                        project.open(128, monitor);
                    }
                } else {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                    project.create(description, (IProgressMonitor)progress.newChild(1));
                    project.open(128, (IProgressMonitor)progress.newChild(1));
                }
            }
        }
        catch (CoreException e) {
            Activator.error(e.getMessage(), e);
        }
    }
}

