/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Arrays;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import org.eclipse.jdt.internal.core.NamedMember;

public interface AbstractModule
extends IModuleDescription {
    public Object getElementInfo() throws JavaModelException;

    default public IModule getModuleInfo() throws JavaModelException {
        return (IModule)this.getElementInfo();
    }

    default public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
        return this.getModuleInfo().requires();
    }

    default public IModule.IPackageExport[] getExportedPackages() throws JavaModelException {
        return this.getModuleInfo().exports();
    }

    default public IModule.IService[] getProvidedServices() throws JavaModelException {
        return this.getModuleInfo().provides();
    }

    default public char[][] getUsedServices() throws JavaModelException {
        return this.getModuleInfo().uses();
    }

    default public IModule.IPackageExport[] getOpenedPackages() throws JavaModelException {
        return this.getModuleInfo().opens();
    }

    @Override
    default public String[] getRequiredModuleNames() throws JavaModelException {
        IModule.IModuleReference[] references = this.getRequiredModules();
        return (String[])Arrays.stream(references).map(ref -> String.valueOf(ref.name())).toArray(String[]::new);
    }

    default public String toString(String lineDelimiter) {
        StringBuffer buffer = new StringBuffer();
        try {
            this.toStringContent(buffer, lineDelimiter);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    default public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
        int i;
        IModule.IPackageExport[] exports = this.getExportedPackages();
        IModule.IModuleReference[] requires = this.getRequiredModules();
        buffer.append("module ");
        buffer.append(this.getElementName()).append(' ');
        buffer.append('{').append(lineDelimiter);
        if (exports != null) {
            i = 0;
            while (i < exports.length) {
                buffer.append("\texports ");
                buffer.append(exports[i].toString());
                buffer.append(lineDelimiter);
                ++i;
            }
        }
        buffer.append(lineDelimiter);
        if (requires != null) {
            i = 0;
            while (i < requires.length) {
                buffer.append("\trequires ");
                if (requires[i].isTransitive()) {
                    buffer.append(" public ");
                }
                buffer.append(requires[i].name());
                buffer.append(';').append(lineDelimiter);
                ++i;
            }
        }
        buffer.append(lineDelimiter).append('}').toString();
    }

    @Override
    default public int getElementType() {
        return 17;
    }

    public static class AutoModule
    extends NamedMember
    implements AbstractModule {
        private boolean nameFromManifest;

        public AutoModule(JavaElement parent, String name, boolean nameFromManifest) {
            super(parent, name);
            this.nameFromManifest = nameFromManifest;
        }

        @Override
        public IJavaElement[] getChildren() throws JavaModelException {
            return JavaElement.NO_ELEMENTS;
        }

        @Override
        public int getFlags() throws JavaModelException {
            return 0;
        }

        @Override
        public boolean isAutoModule() {
            return true;
        }

        public boolean isAutoNameFromManifest() {
            return this.nameFromManifest;
        }

        @Override
        public char getHandleMementoDelimiter() {
            return '`';
        }

        @Override
        public ITypeRoot getTypeRoot() {
            return null;
        }

        @Override
        public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
            return ModuleDescriptionInfo.NO_REQUIRES;
        }

        @Override
        public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
            buffer.append("automatic module ");
            buffer.append(this.name);
        }
    }
}

