/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ITreeModelViewer;
import org.eclipse.jface.viewers.Viewer;

public abstract class AbstractModelProxy
implements IModelProxy2 {
    private IPresentationContext fContext;
    private boolean fInstalled = false;
    private ITreeModelViewer fViewer;
    private boolean fDisposed = false;
    private Job fInstallJob;
    private ListenerList<IModelChangedListener> fListeners = new ListenerList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ListenerList<IModelChangedListener> getListeners() {
        ListenerList<IModelChangedListener> listenerList = this.fListeners;
        synchronized (listenerList) {
            return this.fListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        ListenerList<IModelChangedListener> listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        ListenerList<IModelChangedListener> listenerList = this.fListeners;
        synchronized (listenerList) {
            this.fListeners.remove((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireModelChanged(IModelDelta delta) {
        AbstractModelProxy abstractModelProxy = this;
        synchronized (abstractModelProxy) {
            if (!this.fInstalled || this.fDisposed) {
                return;
            }
        }
        final IModelDelta root = this.getRootDelta(delta);
        Iterator iterator = this.getListeners().iterator();
        while (iterator.hasNext()) {
            IModelChangedListener iModelChangedListener;
            final IModelChangedListener listener = iModelChangedListener = (IModelChangedListener)iterator.next();
            ISafeRunnable safeRunnable = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }

                public void run() throws Exception {
                    listener.modelChanged(root, AbstractModelProxy.this);
                }
            };
            SafeRunner.run((ISafeRunnable)safeRunnable);
        }
    }

    protected IModelDelta getRootDelta(IModelDelta delta) {
        IModelDelta parent = delta.getParentDelta();
        while (parent != null) {
            delta = parent;
            parent = delta.getParentDelta();
        }
        return delta;
    }

    @Override
    public synchronized void dispose() {
        if (this.fInstallJob != null) {
            this.fInstallJob.cancel();
            this.fInstallJob = null;
        }
        this.fDisposed = true;
        this.fContext = null;
        this.fViewer = null;
    }

    protected synchronized void setInstalled(boolean installed) {
        this.fInstalled = installed;
    }

    protected synchronized boolean isInstalled() {
        return this.fInstalled;
    }

    protected synchronized void setDisposed(boolean disposed) {
        this.fDisposed = disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(ITreeModelViewer viewer) {
        this.setDisposed(false);
        AbstractModelProxy abstractModelProxy = this;
        synchronized (abstractModelProxy) {
            this.fViewer = viewer;
            this.fContext = viewer.getPresentationContext();
            this.fInstallJob = new Job("Model Proxy installed notification job"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        AbstractModelProxy.this.fInstallJob = null;
                    }
                    if (!monitor.isCanceled()) {
                        AbstractModelProxy.this.init(AbstractModelProxy.this.getTreeModelViewer().getPresentationContext());
                        AbstractModelProxy.this.setInstalled(true);
                        AbstractModelProxy.this.installed(AbstractModelProxy.this.getViewer());
                    }
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return AbstractModelProxy.this == family;
                }

                public boolean shouldRun() {
                    return !AbstractModelProxy.this.isDisposed();
                }
            };
            this.fInstallJob.setSystem(true);
        }
        this.fInstallJob.schedule();
    }

    public synchronized IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    @Override
    public void init(IPresentationContext context) {
    }

    @Override
    public void installed(Viewer viewer) {
    }

    protected Viewer getViewer() {
        return (Viewer)this.fViewer;
    }

    protected ITreeModelViewer getTreeModelViewer() {
        return this.fViewer;
    }

    @Override
    public synchronized boolean isDisposed() {
        return this.fDisposed;
    }
}

