/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsProcessor;
import org.eclipse.pde.ui.launcher.MainTab;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class LauncherUtilsStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        int code = status.getCode();
        switch (code) {
            case 2000: {
                Object[] args = (Object[])source;
                this.handleWorkspaceLocked((String)args[0], (ILaunchConfiguration)args[1], (String)args[2]);
                break;
            }
            case 2001: {
                return this.clearLog();
            }
            case 2002: {
                return this.deleteWorkspace((String)source);
            }
            case 2003: {
                return this.generateConfigIni();
            }
            case 2004: {
                Object[] args2 = (Object[])source;
                this.organizeManifests((ArrayList)args2[0], (IProgressMonitor)args2[1], (Properties)args2[2]);
                break;
            }
            case 2005: {
                ILaunchConfigurationDialog dialog = (ILaunchConfigurationDialog)source;
                this.selectWorkspaceField(dialog);
            }
        }
        return null;
    }

    private void selectWorkspaceField(ILaunchConfigurationDialog dialog) {
        ILaunchConfigurationTab[] tabs = dialog.getTabs();
        if (tabs != null) {
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs;
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
                if (tab instanceof MainTab) {
                    MainTab mainTab = (MainTab)tab;
                    dialog.setActiveTab((ILaunchConfigurationTab)mainTab);
                    mainTab.applyData("location");
                }
                ++n2;
            }
        }
    }

    private Boolean generateConfigIni() {
        String message = PDEUIMessages.LauncherUtils_generateConfigIni;
        return LauncherUtilsStatusHandler.generateDialog(message) == 0;
    }

    private Integer deleteWorkspace(String path) {
        return LauncherUtilsStatusHandler.generateDialog(NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_confirmDeleteWorkspace, (Object)path));
    }

    private Integer clearLog() {
        return LauncherUtilsStatusHandler.generateDialog(PDEUIMessages.LauncherUtils_clearLogFile);
    }

    private void handleWorkspaceLocked(String workspace, ILaunchConfiguration launchConfig, String mode) {
        String message = NLS.bind((String)PDEMessages.LauncherUtils_cannotLaunchApplication, (Object)workspace);
        LauncherUtilsStatusHandler.generateErrorDialog(PDEUIMessages.LauncherUtils_workspaceLocked, message, launchConfig, mode);
    }

    private void organizeManifests(ArrayList<?> projects, IProgressMonitor monitor, Properties lastRun) {
        Display.getDefault().syncExec(() -> {
            OrganizeManifestsProcessor processor = new OrganizeManifestsProcessor(projects);
            LauncherUtilsStatusHandler.initializeProcessor(processor);
            try {
                Change change = processor.createChange(monitor);
                change.perform(monitor);
                Properties table = lastRun;
                String ts = Long.toString(System.currentTimeMillis());
                Iterator it = projects.iterator();
                while (it.hasNext()) {
                    table.put(((IProject)it.next()).getName(), ts);
                }
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (CoreException coreException) {}
        });
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static final Shell getActiveShell() {
        IWorkbenchWindow window = PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PDEPlugin.getDefault().getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return LauncherUtilsStatusHandler.getDisplay().getActiveShell();
    }

    private static void initializeProcessor(OrganizeManifestsProcessor processor) {
        processor.setAddMissing(false);
        processor.setRemoveUnresolved(false);
        processor.setModifyDep(false);
        processor.setRemoveLazy(false);
        processor.setRemoveUselessFiles(false);
        processor.setAddDependencies(true);
        processor.setCalculateUses(false);
        processor.setMarkInternal(false);
        processor.setPrefixIconNL(false);
        processor.setUnusedDependencies(false);
        processor.setUnusedKeys(false);
    }

    private static Integer generateDialog(String message) {
        int[] result = new int[1];
        LauncherUtilsStatusHandler.getDisplay().syncExec(() -> {
            String title = PDEUIMessages.LauncherUtils_title;
            MessageDialog dialog = new MessageDialog(LauncherUtilsStatusHandler.getActiveShell(), title, null, message, 3, 0, new String[]{PDEUIMessages.WorkbenchLauncherConfigurationDelegate_clearButtonLabel, PDEUIMessages.WorkbenchLauncherConfigurationDelegate_dontClearButtonLabel, IDialogConstants.CANCEL_LABEL});
            nArray[0] = dialog.open();
        });
        return result[0];
    }

    private static void generateErrorDialog(String title, String message, ILaunchConfiguration launchConfig, String mode) {
        LauncherUtilsStatusHandler.getDisplay().syncExec(() -> {
            Shell parentShell = LauncherUtilsStatusHandler.getActiveShell();
            MessageDialog dialog = new MessageDialog(parentShell, title, null, message, 1, 1, new String[]{PDEUIMessages.LauncherUtils_edit, PDEUIMessages.LauncherUtils_cancelLaunch});
            int res = dialog.open();
            if (res == 0) {
                StructuredSelection selection = new StructuredSelection((Object)launchConfig);
                ILaunchGroup group = DebugUITools.getLaunchGroup((ILaunchConfiguration)launchConfig, (String)mode);
                String groupIdentifier = group == null ? "org.eclipse.debug.ui.launchGroup.run" : group.getIdentifier();
                Status status = new Status(0, PDELaunchingPlugin.getPluginId(), 2005, "", null);
                DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)parentShell, (IStructuredSelection)selection, (String)groupIdentifier, (IStatus)status);
            }
        });
    }
}

