/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaDescriptor;
import org.eclipse.pde.internal.core.schema.Schema;

public class StorageSchemaDescriptor
implements ISchemaDescriptor {
    private IStorage fStorage;
    private Schema fSchema;

    public StorageSchemaDescriptor(IStorage storage) {
        this.fStorage = storage;
    }

    @Override
    public URL getSchemaURL() {
        return this.fSchema != null ? this.fSchema.getURL() : null;
    }

    @Override
    public String getPointId() {
        return this.fSchema == null ? null : this.fSchema.getQualifiedPointId();
    }

    protected void loadSchema(boolean abbreviated) {
        this.fSchema = new Schema(this, null, false);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = this.fStorage.getContents();){
                this.fSchema.load(this.fStorage.getContents());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            PDECore.logException(e);
        }
    }

    public void reload() {
        if (this.fSchema != null) {
            this.fSchema.reload();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public ISchema getSchema(boolean abbreviated) {
        if (this.fSchema == null) {
            this.loadSchema(abbreviated);
        }
        return this.fSchema;
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }
}

