/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.resources.nested;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.navigator.resources.nested.NestedProjectManager;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.ui.internal.navigator.resources.workbench.ResourceExtensionLabelProvider;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;

public class NestedProjectsLabelProvider
extends ResourceExtensionLabelProvider {
    private CompletableFuture<Map<IContainer, Integer>> severitiesPerContainer = null;
    private IResourceChangeListener refreshSeveritiesOnProblemMarkerChange;

    @Override
    public void init(ICommonContentExtensionSite aConfig) {
        super.init(aConfig);
        this.severitiesPerContainer = this.refreshSeverities();
        this.refreshSeveritiesOnProblemMarkerChange = event -> {
            if (event.getDelta() == null) {
                return;
            }
            MarkerManager markerManager = ((Workspace)WorkbenchNavigatorPlugin.getWorkspace()).getMarkerManager();
            try {
                event.getDelta().accept(delta -> {
                    if (this.severitiesPerContainer != null) {
                        IMarkerDelta[] markerDeltas;
                        IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                        int n = markerDeltas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                            if (markerManager.isSubtype(markerDelta.getType(), "org.eclipse.core.resources.problemmarker")) {
                                this.severitiesPerContainer.cancel(true);
                                this.severitiesPerContainer = null;
                                return false;
                            }
                            ++n2;
                        }
                    }
                    return true;
                });
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            if (this.severitiesPerContainer == null) {
                this.severitiesPerContainer = this.refreshSeverities();
            }
        };
        WorkbenchNavigatorPlugin.getWorkspace().addResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
    }

    public void dispose() {
        WorkbenchNavigatorPlugin.getWorkspace().removeResourceChangeListener(this.refreshSeveritiesOnProblemMarkerChange);
        super.dispose();
    }

    private CompletableFuture<Map<IContainer, Integer>> refreshSeverities() {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<IContainer, Integer> severities = new HashMap<IContainer, Integer>();
            try {
                IMarker[] iMarkerArray = WorkbenchNavigatorPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    int severity = marker.getAttribute("severity", -1);
                    IContainer container = marker.getResource().getParent();
                    if (marker.getResource() instanceof IContainer) {
                        container = (IContainer)marker.getResource();
                    }
                    while (container != null) {
                        if (!severities.containsKey(container) || (Integer)severities.get(container) < severity) {
                            severities.put(container, severity);
                            if (container.getType() == 2) {
                                container = container.getParent();
                                continue;
                            }
                            if (container.getType() == 4) {
                                container = NestedProjectManager.getInstance().getMostDirectOpenContainer((IProject)container);
                                continue;
                            }
                            container = null;
                            continue;
                        }
                        container = null;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
                throw new RuntimeException(e);
            }
            return severities;
        });
    }

    protected String decorateText(String input, Object element) {
        super.decorateText(input, element);
        if (!(element instanceof IProject)) {
            return input;
        }
        IProject project = (IProject)element;
        IPath location = project.getLocation();
        if (location != null && !location.lastSegment().equals(project.getName())) {
            return String.valueOf(input) + " (in " + location.lastSegment() + ")";
        }
        return input;
    }

    @Override
    protected int getHighestProblemSeverity(IResource resource) {
        int problemSeverity = super.getHighestProblemSeverity(resource);
        if (resource instanceof IContainer && problemSeverity < 2) {
            try {
                Integer severity;
                CompletableFuture<Map<IContainer, Integer>> severitiesSnapshot = this.severitiesPerContainer;
                if (severitiesSnapshot != null && (severity = severitiesSnapshot.get(50L, TimeUnit.MILLISECONDS).get(resource)) != null) {
                    problemSeverity = Math.max(problemSeverity, severity);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                WorkbenchNavigatorPlugin.log(e.getMessage(), (IStatus)new Status(4, WorkbenchNavigatorPlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
        }
        return problemSeverity;
    }
}

