/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.job.JobUtil;
import org.eclipse.egit.core.internal.storage.CommitFileRevision;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.blame.BlameOperation;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowBlameActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = ShowBlameActionHandler.getSelection(event);
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        IResource resource = (IResource)AdapterUtils.adapt((Object)element, IResource.class);
        if (resource instanceof IFile) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null) {
                String repoRelativePath = mapping.getRepoRelativePath(resource);
                Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
                IWorkbenchPage page = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage();
                JobUtil.scheduleUserJob((IEGitOperation)new BlameOperation(mapping.getRepository(), (IFile)resource, repoRelativePath, null, shell, page), (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
            }
        } else if (element instanceof CommitFileRevision) {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            IWorkbenchPage page = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage();
            JobUtil.scheduleUserJob((IEGitOperation)new BlameOperation((CommitFileRevision)element, shell, page), (String)UIText.ShowBlameHandler_JobName, (Object)JobFamilies.BLAME);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        Object element = selection.getFirstElement();
        IResource resource = (IResource)AdapterUtils.adapt((Object)element, IResource.class);
        if (resource instanceof IStorage) {
            return RepositoryMapping.getMapping((IResource)resource) != null;
        }
        return element instanceof CommitFileRevision;
    }
}

