/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.pull;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.PullOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.pull.MultiPullResultDialog;
import org.eclipse.egit.ui.internal.pull.PullResultDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PullOperationUI
extends JobChangeAdapter {
    private static final IStatus NOT_TRIED_STATUS = new Status(4, Activator.getPluginId(), UIText.PullOperationUI_NotTriedMessage);
    private final Repository[] repositories;
    private final AtomicInteger tasksToWaitFor = new AtomicInteger(1);
    protected final Map<Repository, Object> results = Collections.synchronizedMap(new LinkedHashMap());
    private final PullOperation pullOperation;
    private boolean checkForLaunches = true;

    public PullOperationUI(Set<Repository> repositories) {
        this.repositories = repositories.toArray(new Repository[repositories.size()]);
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        this.pullOperation = new PullOperation(repositories, timeout);
        this.pullOperation.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        for (Repository repository : repositories) {
            this.results.put(repository, NOT_TRIED_STATUS);
        }
    }

    public PullOperationUI(Map<Repository, PullOperation.PullReferenceConfig> configs) {
        this.repositories = configs.keySet().toArray(new Repository[0]);
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        this.pullOperation = new PullOperation(configs, timeout);
        this.pullOperation.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        Repository[] repositoryArray = this.repositories;
        int n = this.repositories.length;
        int n2 = 0;
        while (n2 < n) {
            Repository repository = repositoryArray[n2];
            this.results.put(repository, NOT_TRIED_STATUS);
            ++n2;
        }
    }

    public void start() {
        this.start((IJobChangeListener)this);
    }

    private void start(IJobChangeListener jobChangeListener) {
        String jobName;
        if (this.checkForLaunches && LaunchFinder.shouldCancelBecauseOfRunningLaunches(Arrays.asList(this.repositories), null)) {
            return;
        }
        if (this.repositories.length == 1) {
            String shortBranchName;
            String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(this.repositories[0]);
            try {
                shortBranchName = this.repositories[0].getBranch();
            }
            catch (IOException e) {
                shortBranchName = "";
            }
            jobName = NLS.bind((String)UIText.PullOperationUI_PullingTaskName, (Object)shortBranchName, (Object)repoName);
        } else {
            jobName = UIText.PullOperationUI_PullingMultipleTaskName;
        }
        WorkspaceJob job = new WorkspaceJob(jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                PullOperationUI.this.execute(monitor, false);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (JobFamilies.PULL.equals(family)) {
                    return true;
                }
                return super.belongsTo(family);
            }
        };
        job.setRule(RuleUtil.getRuleForRepositories(Arrays.asList(this.repositories)));
        job.setUser(true);
        job.addJobChangeListener(jobChangeListener);
        job.schedule();
    }

    public void execute(IProgressMonitor monitor) {
        this.execute(monitor, true);
    }

    private void execute(IProgressMonitor monitor, boolean launchCheck) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(launchCheck ? 11 : 10));
        if (launchCheck && LaunchFinder.shouldCancelBecauseOfRunningLaunches(Arrays.asList(this.repositories), (IProgressMonitor)progress.newChild(1))) {
            return;
        }
        try {
            this.pullOperation.execute((IProgressMonitor)progress.newChild(10));
            this.results.putAll(this.pullOperation.getResults());
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                this.results.putAll(this.pullOperation.getResults());
            }
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    public void done(IJobChangeEvent event) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LinkedHashMap<Repository, Object> res = new LinkedHashMap<Repository, Object>(PullOperationUI.this.results);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PullOperationUI.this.handlePullResults(res, shell);
            }
        });
    }

    private void handlePullResults(Map<Repository, Object> resultsMap, Shell shell) {
        for (Map.Entry<Repository, Object> entry : resultsMap.entrySet()) {
            PullResult pullResult;
            Object result = entry.getValue();
            if (!(result instanceof PullResult) || (pullResult = (PullResult)result).getRebaseResult() == null || RebaseResult.Status.UNCOMMITTED_CHANGES != pullResult.getRebaseResult().getStatus()) continue;
            this.handleUncommittedChanges(entry.getKey(), pullResult.getRebaseResult().getUncommittedChanges(), shell);
        }
        if (this.tasksToWaitFor.decrementAndGet() == 0 && !this.results.isEmpty()) {
            this.showResults(shell);
        }
    }

    private void handleUncommittedChanges(Repository repository, List<String> files, Shell shell) {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
        CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, MessageFormat.format(UIText.AbstractRebaseCommandHandler_cleanupDialog_title, repoName), UIText.AbstractRebaseCommandHandler_cleanupDialog_text, repository, files);
        cleanupUncomittedChangesDialog.open();
        if (cleanupUncomittedChangesDialog.shouldContinue()) {
            final PullOperationUI parentOperation = this;
            final PullOperationUI pullOperationUI = new PullOperationUI(Collections.singleton(repository));
            pullOperationUI.checkForLaunches = false;
            this.tasksToWaitFor.incrementAndGet();
            pullOperationUI.start((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    parentOperation.results.putAll(pullOperationUI.results);
                    int missing = parentOperation.tasksToWaitFor.decrementAndGet();
                    if (missing == 0) {
                        parentOperation.showResults();
                    }
                }
            });
        }
    }

    private void showResults() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                PullOperationUI.this.showResults(shell);
            }
        });
    }

    private void showResults(Shell shell) {
        if (this.results.isEmpty()) {
            return;
        }
        if (this.results.size() == 1) {
            Map.Entry<Repository, Object> entry = this.results.entrySet().iterator().next();
            if (entry.getValue() instanceof PullResult) {
                new PullResultDialog(shell, entry.getKey(), (PullResult)entry.getValue()).open();
            } else {
                IStatus status = (IStatus)entry.getValue();
                if (status == NOT_TRIED_STATUS) {
                    MessageDialog.openInformation((Shell)shell, (String)UIText.PullOperationUI_PullCanceledWindowTitle, (String)UIText.PullOperationUI_PullOperationCanceledMessage);
                } else if (status.getException() instanceof TransportException) {
                    ErrorDialog.openError((Shell)shell, (String)UIText.PullOperationUI_PullFailed, (String)UIText.PullOperationUI_ConnectionProblem, (IStatus)status);
                } else {
                    Activator.handleError(status.getMessage(), status.getException(), true);
                }
            }
        } else {
            new MultiPullResultDialog(shell, this.results).open();
        }
    }
}

