/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.debug.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventType implements Enumerator
{
    STARTED(0, "Started", "Started"),
    SUSPENDED(1, "Suspended", "Suspended"),
    STEP_ENDED(2, "StepEnded", "StepEnded"),
    BREAKPOINT_HIT(3, "BreakpointHit", "BreakpointHit"),
    RESUMED(4, "Resumed", "Resumed"),
    RESOLVE_VARIABLE(5, "ResolveVariable", "ResolveVariable");

    public static final int STARTED_VALUE = 0;
    public static final int SUSPENDED_VALUE = 1;
    public static final int STEP_ENDED_VALUE = 2;
    public static final int BREAKPOINT_HIT_VALUE = 3;
    public static final int RESUMED_VALUE = 4;
    public static final int RESOLVE_VARIABLE_VALUE = 5;
    private static final EventType[] VALUES_ARRAY;
    public static final List<EventType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventType[]{STARTED, SUSPENDED, STEP_ENDED, BREAKPOINT_HIT, RESUMED, RESOLVE_VARIABLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventType get(int value) {
        switch (value) {
            case 0: {
                return STARTED;
            }
            case 1: {
                return SUSPENDED;
            }
            case 2: {
                return STEP_ENDED;
            }
            case 3: {
                return BREAKPOINT_HIT;
            }
            case 4: {
                return RESUMED;
            }
            case 5: {
                return RESOLVE_VARIABLE;
            }
        }
        return null;
    }

    private EventType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

