/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.runner;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.rcptt.internal.launching.Q7LaunchManager;
import org.eclipse.rcptt.runner.HeadlessRunner;
import org.eclipse.rcptt.runner.RunnerConfiguration;
import org.eclipse.rcptt.runner.util.AutLaunchFail;
import org.eclipse.rcptt.runner.util.TargetPlatformFail;

public class HeadlessRunnerApp
implements IApplication {
    public static final String RETURN_TEST_FAILURE_PROPERTY = "org.eclipse.rcptt.runner.returnTestFailure";
    public static final int TEST_FAIL_EXIT_CODE = 56;
    public static final int TARGET_PLATFORM_FAIL_EXIT_CODE = 62;
    public static final int AUT_FAIL_EXIT_CODE = 63;
    public static final int ILLEGAL_ARGUMENT = 64;

    public Object start(IApplicationContext context) throws Exception {
        HeadlessRunnerApp.disableProxyService();
        System.out.println("Started at " + new Date(System.currentTimeMillis()));
        System.out.println(String.format("RCPTT Runner version: %s", HeadlessRunnerApp.getRunnerVersion()));
        String[] cmdLineArgs = HeadlessRunnerApp.deQuoteArgs((String[])context.getArguments().get("application.args"));
        Q7LaunchManager.makeHeadless();
        RunnerConfiguration conf = new RunnerConfiguration();
        if (!conf.processArgs(cmdLineArgs)) {
            return 64;
        }
        boolean returnTestFailure = Boolean.valueOf(System.getProperty(RETURN_TEST_FAILURE_PROPERTY, "true"));
        try {
            int failCount = new HeadlessRunner(conf).performCoolThings();
            if (failCount == 0) {
                System.out.println("Finished at " + new Date(System.currentTimeMillis()));
                return IApplication.EXIT_OK;
            }
            return returnTestFailure ? 56 : IApplication.EXIT_OK;
        }
        catch (AutLaunchFail autLaunchFail) {
            return 63;
        }
        catch (TargetPlatformFail targetPlatformFail) {
            return 62;
        }
    }

    private static void disableProxyService() {
        System.setProperty("org.eclipse.net.core.enableProxyService", "false");
    }

    public void stop() {
    }

    private static String getRunnerVersion() {
        String version = (String)Platform.getBundle((String)"org.eclipse.rcptt.runner").getHeaders().get("Bundle-Version");
        if (version == null) {
            return "[unknown]";
        }
        int dotPos = version.lastIndexOf(46);
        if (dotPos < 0) {
            return version;
        }
        return version.substring(0, dotPos);
    }

    private static String[] deQuoteArgs(String[] args) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            result.add(HeadlessRunnerApp.deQuote(arg));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static String deQuote(String line) {
        if (line != null) {
            if (line.startsWith("'") && line.endsWith("'")) {
                line = line.substring(1, line.length() - 1);
            }
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.substring(1, line.length() - 1);
            }
        }
        return line;
    }
}

