/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalJavaSearchClasspathContainer;
import org.eclipse.pde.internal.core.FileAdapter;
import org.eclipse.pde.internal.core.IFileAdapterFactory;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.util.CoreUtility;

public class SearchablePluginsManager
implements IFileAdapterFactory,
IPluginModelListener {
    private static final String PROXY_FILE_NAME = ".searchable";
    public static final String PROXY_PROJECT_NAME = "External Plug-in Libraries";
    private static final String KEY = "searchablePlugins";
    private final Listener fElementListener;
    private Set<String> fPluginIdSet = SearchablePluginsManager.loadStates();
    private ArrayList<IPluginModelListener> fListeners;

    public SearchablePluginsManager() {
        this.fElementListener = new Listener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        PDECore.getDefault().getModelManager().addPluginModelListener(this);
    }

    private static Set<String> loadStates() {
        TreeSet<String> set;
        block14: {
            set = new TreeSet<String>();
            IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
            IProject project = root.getProject(PROXY_PROJECT_NAME);
            try {
                IFile proxyFile;
                if (!project.exists() || !project.isOpen() || !(proxyFile = project.getFile(PROXY_FILE_NAME)).exists()) break block14;
                Properties properties = new Properties();
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream stream = proxyFile.getContents(true);){
                    properties.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                String value = properties.getProperty(KEY);
                if (value != null) {
                    StringTokenizer stok = new StringTokenizer(value, ",");
                    while (stok.hasMoreTokens()) {
                        set.add(stok.nextToken());
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
        }
        return set;
    }

    public IJavaProject getProxyProject() {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IProject project = root.getProject(PROXY_PROJECT_NAME);
        try {
            if (project.exists() && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void shutdown() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
        PDECore.getDefault().getModelManager().removePluginModelListener(this);
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClasspathEntry[] computeContainerClasspathEntries() throws CoreException {
        ModelEntry entry;
        ArrayList<String> plugins;
        IPluginModelBase[] wModels;
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IPluginModelBase[] iPluginModelBaseArray = wModels = PluginRegistry.getWorkspaceModels();
        int n = wModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            IProject project = model.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                result.add(JavaCore.newProjectEntry((IPath)project.getFullPath()));
            }
            ++n2;
        }
        Set<String> set = this.fPluginIdSet;
        synchronized (set) {
            plugins = new ArrayList<String>(this.fPluginIdSet);
        }
        for (String id : plugins) {
            IPluginModelBase[] models;
            entry = PluginRegistry.findEntry(id);
            if (entry == null) continue;
            boolean addModel = true;
            IPluginModelBase[] iPluginModelBaseArray2 = wModels = entry.getWorkspaceModels();
            int n3 = wModels.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginModelBase model = iPluginModelBaseArray2[n4];
                IProject project = model.getUnderlyingResource().getProject();
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    addModel = false;
                }
                ++n4;
            }
            if (!addModel) continue;
            IPluginModelBase[] iPluginModelBaseArray3 = models = entry.getExternalModels();
            int n5 = models.length;
            n3 = 0;
            while (n3 < n5) {
                IPluginModelBase model = iPluginModelBaseArray3[n3];
                if (model.isEnabled()) {
                    ClasspathUtilCore.addLibraries(model, result);
                }
                ++n3;
            }
        }
        if (result.size() > 1) {
            TreeMap<String, ModelEntry> map = new TreeMap<String, ModelEntry>();
            int i = 0;
            while (i < result.size()) {
                entry = (IClasspathEntry)result.get(i);
                String key = entry.getPath().lastSegment().toString();
                while (map.containsKey(key)) {
                    key = String.valueOf(key) + i;
                }
                map.put(key, entry);
                ++i;
            }
            return map.values().toArray(new IClasspathEntry[map.size()]);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }

    @Override
    public Object createAdapterChild(FileAdapter parent, File file) {
        IPackageFragmentRoot root;
        if (!file.isDirectory() && file.isFile() && (root = this.findPackageFragmentRoot((IPath)new Path(file.getAbsolutePath()))) != null) {
            return root;
        }
        return new FileAdapter(parent, file, this);
    }

    private IPackageFragmentRoot findPackageFragmentRoot(IPath jarPath) {
        IPluginModelBase[] pluginModels;
        int n;
        int n2;
        IPluginModelBase[] iPluginModelBaseArray;
        IJavaProject jProject = this.getProxyProject();
        if (jProject != null) {
            try {
                IPackageFragmentRoot[] roots = jProject.getAllPackageFragmentRoots();
                iPluginModelBaseArray = roots;
                n2 = roots.length;
                n = 0;
                while (n < n2) {
                    IPluginModelBase root = iPluginModelBaseArray[n];
                    IPath path = root.getPath();
                    if (path.equals((Object)jarPath)) {
                        return root;
                    }
                    ++n;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        iPluginModelBaseArray = pluginModels = PluginRegistry.getWorkspaceModels();
        n2 = pluginModels.length;
        n = 0;
        while (n < n2) {
            IPluginModelBase model = iPluginModelBaseArray[n];
            IProject project = model.getUnderlyingResource().getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPackageFragmentRoot[] roots;
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    IPath path = root.getPath();
                    if (path.equals((Object)jarPath)) {
                        return root;
                    }
                    ++n4;
                }
            }
            catch (JavaModelException javaModelException) {}
            ++n;
        }
        return null;
    }

    private void checkForProxyProject() {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        try {
            IProject project = root.getProject(PROXY_PROJECT_NAME);
            if (!project.exists()) {
                this.createProxyProject((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException coreException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToJavaSearch(IPluginModelBase[] models) {
        this.checkForProxyProject();
        PluginModelDelta delta = new PluginModelDelta();
        HashSet<String> toAdd = new HashSet<String>();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (!this.isInJavaSearch(id) && !toAdd.contains(id)) {
                toAdd.add(id);
                ModelEntry entry = PluginRegistry.findEntry(id);
                if (entry != null) {
                    delta.addEntry(entry, 4);
                }
            }
            ++n2;
        }
        if (!toAdd.isEmpty()) {
            Set<String> set = this.fPluginIdSet;
            synchronized (set) {
                this.fPluginIdSet.addAll(toAdd);
            }
            this.resetContainer();
            this.fireDelta(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromJavaSearch(IPluginModelBase[] models) {
        PluginModelDelta delta = new PluginModelDelta();
        HashSet<String> toRemove = new HashSet<String>();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (this.isInJavaSearch(id)) {
                toRemove.add(id);
                ModelEntry entry = PluginRegistry.findEntry(id);
                if (entry != null) {
                    delta.addEntry(entry, 4);
                }
            }
            ++n2;
        }
        if (!toRemove.isEmpty()) {
            Set<String> set = this.fPluginIdSet;
            synchronized (set) {
                this.fPluginIdSet.removeAll(toRemove);
            }
            this.resetContainer();
            this.fireDelta(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllFromJavaSearch() {
        Set<String> oldIds;
        Set<String> set = this.fPluginIdSet;
        synchronized (set) {
            oldIds = this.fPluginIdSet;
            this.fPluginIdSet = new TreeSet<String>();
        }
        if (!oldIds.isEmpty()) {
            PluginModelDelta delta = new PluginModelDelta();
            for (String id : oldIds) {
                ModelEntry entry = PluginRegistry.findEntry(id);
                if (entry == null) continue;
                delta.addEntry(entry, 4);
            }
            this.resetContainer();
            this.fireDelta(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInJavaSearch(String symbolicName) {
        Set<String> set = this.fPluginIdSet;
        synchronized (set) {
            return this.fPluginIdSet.contains(symbolicName);
        }
    }

    private void resetContainer() {
        IJavaProject jProject = this.getProxyProject();
        try {
            if (jProject != null) {
                JavaCore.setClasspathContainer((IPath)PDECore.JAVA_SEARCH_CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{jProject}, (IClasspathContainer[])new IClasspathContainer[]{new ExternalJavaSearchClasspathContainer()}, null);
                this.saveStates();
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modelsChanged(PluginModelDelta delta) {
        ModelEntry[] entries = delta.getRemovedEntries();
        Set<String> set = this.fPluginIdSet;
        synchronized (set) {
            ModelEntry[] modelEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                ModelEntry entry = modelEntryArray[n2];
                if (this.fPluginIdSet.contains(entry.getId())) {
                    this.fPluginIdSet.remove(entry.getId());
                }
                ++n2;
            }
        }
        this.resetContainer();
    }

    private void fireDelta(PluginModelDelta delta) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                this.fListeners.get(i).modelsChanged(delta);
                ++i;
            }
        }
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStates() {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IProject project = root.getProject(PROXY_PROJECT_NAME);
        if (project.exists() && project.isOpen()) {
            String propertyToSave;
            Set<String> loadedStates = SearchablePluginsManager.loadStates();
            Set<String> set = this.fPluginIdSet;
            synchronized (set) {
                if (loadedStates.equals(this.fPluginIdSet)) {
                    return;
                }
                propertyToSave = this.fPluginIdSet.stream().collect(Collectors.joining(","));
            }
            IFile file = project.getFile(PROXY_FILE_NAME);
            Properties properties = new Properties();
            properties.setProperty(KEY, propertyToSave);
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();){
                    properties.store(outStream, "");
                    outStream.flush();
                    outStream.close();
                    Throwable throwable2 = null;
                    Object var11_16 = null;
                    try (ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());){
                        if (file.exists()) {
                            file.setContents((InputStream)inStream, true, false, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            file.create((InputStream)inStream, true, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.log(e);
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
    }

    public IProject createProxyProject(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IProject project = root.getProject(PROXY_PROJECT_NAME);
        if (project.exists()) {
            if (!project.isOpen()) {
                project.open(monitor);
            }
            return project;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)PDECoreMessages.SearchablePluginsManager_createProjectTaskName, (Object)PROXY_PROJECT_NAME), (int)5);
        project.create((IProgressMonitor)subMonitor.split(1));
        project.open((IProgressMonitor)subMonitor.split(1));
        CoreUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", (IProgressMonitor)subMonitor.split(1));
        IJavaProject jProject = JavaCore.create((IProject)project);
        jProject.setOutputLocation(project.getFullPath(), (IProgressMonitor)subMonitor.split(1));
        this.computeClasspath(jProject, (IProgressMonitor)subMonitor.split(1));
        return project;
    }

    private void computeClasspath(IJavaProject project, IProgressMonitor monitor) {
        IClasspathEntry[] classpath = new IClasspathEntry[]{JavaCore.newContainerEntry((IPath)JavaRuntime.newDefaultJREContainerPath()), JavaCore.newContainerEntry((IPath)PDECore.JAVA_SEARCH_CONTAINER_PATH)};
        try {
            project.setRawClasspath(classpath, monitor);
        }
        catch (JavaModelException javaModelException) {}
    }

    class Listener
    implements IElementChangedListener {
        Listener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (e.getType() == 1) {
                this.handleDelta(e.getDelta());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean handleDelta(IJavaElementDelta delta) {
            IJavaElement element = delta.getElement();
            if (element instanceof IJavaModel) {
                IJavaElementDelta[] projectDeltas;
                IJavaElementDelta[] iJavaElementDeltaArray = projectDeltas = delta.getAffectedChildren();
                int n = projectDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta projectDelta = iJavaElementDeltaArray[n2];
                    if (this.handleDelta(projectDelta)) break;
                    ++n2;
                }
                return true;
            }
            if (element instanceof IJavaProject) {
                IJavaProject project = (IJavaProject)element;
                if (project.getElementName().equals(SearchablePluginsManager.PROXY_PROJECT_NAME)) {
                    if (delta.getKind() == 2) {
                        Set projectDelta = SearchablePluginsManager.this.fPluginIdSet;
                        synchronized (projectDelta) {
                            SearchablePluginsManager.this.fPluginIdSet.clear();
                        }
                    }
                    if (delta.getKind() == 1) {
                        boolean emptyIds;
                        Set set = SearchablePluginsManager.this.fPluginIdSet;
                        synchronized (set) {
                            emptyIds = SearchablePluginsManager.this.fPluginIdSet.isEmpty();
                        }
                        if (emptyIds) {
                            Set ids = SearchablePluginsManager.loadStates();
                            Set set2 = SearchablePluginsManager.this.fPluginIdSet;
                            synchronized (set2) {
                                SearchablePluginsManager.this.fPluginIdSet = ids;
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

