/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.quickaccess;

import java.util.Arrays;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public abstract class QuickAccessProvider {
    private QuickAccessElement[] sortedElements;

    public abstract String getId();

    public abstract String getName();

    public abstract ImageDescriptor getImageDescriptor();

    public abstract QuickAccessElement[] getElements();

    public QuickAccessElement[] getElementsSorted() {
        if (this.sortedElements == null) {
            this.sortedElements = this.getElements();
            Arrays.sort(this.sortedElements, (e1, e2) -> e1.getSortLabel().compareTo(e2.getSortLabel()));
        }
        return this.sortedElements;
    }

    public QuickAccessElement getElementForId(String id) {
        if (id == null) {
            return null;
        }
        if (this.sortedElements != null) {
            QuickAccessElement[] quickAccessElementArray = this.sortedElements;
            int n = this.sortedElements.length;
            int n2 = 0;
            while (n2 < n) {
                QuickAccessElement element = quickAccessElementArray[n2];
                if (id.equals(element.getId())) {
                    return element;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isAlwaysPresent() {
        return false;
    }

    public final void reset() {
        this.sortedElements = null;
        this.doReset();
    }

    protected abstract void doReset();

    public boolean requiresUiAccess() {
        return false;
    }
}

