/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetsFilter
extends ViewerFilter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ILaunchConfigurationType) {
            return true;
        }
        if (!(element instanceof ILaunchConfiguration)) return false;
        ILaunchConfiguration config = (ILaunchConfiguration)element;
        try {
            IResource[] resources = config.getMappedResources();
            if (resources == null) {
                return true;
            }
            IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
            if (window == null) {
                return true;
            }
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return true;
            }
            IWorkingSet[] wsets = page.getWorkingSets();
            if (wsets.length < 1) {
                return true;
            }
            ArrayList<IWorkingSet> ws = new ArrayList<IWorkingSet>();
            int i = 0;
            while (true) {
                if (i >= wsets.length) {
                    if (!ws.isEmpty()) break;
                    return true;
                }
                if (!"org.eclipse.debug.ui.breakpointWorkingSet".equals(wsets[i].getId())) {
                    ws.add(wsets[i]);
                }
                ++i;
            }
            i = 0;
            while (true) {
                if (i >= resources.length) {
                    return false;
                }
                if (WorkingSetsFilter.workingSetContains(ws.toArray(new IWorkingSet[ws.size()]), resources[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static boolean workingSetContains(IWorkingSet[] wsets, IResource res) {
        ArrayList<IResource> parents = new ArrayList<IResource>();
        parents.add(res);
        while (res != null) {
            if ((res = res.getParent()) == null) continue;
            parents.add(res);
        }
        IResource lres = null;
        int i = 0;
        while (i < wsets.length) {
            IAdaptable[] elements = wsets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                lres = (IResource)elements[j].getAdapter(IResource.class);
                if (lres != null && parents.contains(lres)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }
}

