/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJMod;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathJrtWithReleaseOption;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiReleaseJar;

public abstract class ClasspathLocation {
    protected boolean isOnModulePath;
    protected IModule module;
    protected IUpdatableModule.UpdatesByKind updates;
    protected Set<String> limitModuleNames = null;
    protected String patchModuleName = null;

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4);

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4, boolean var5, Predicate<String> var6);

    public abstract boolean isPackage(String var1, String var2);

    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        return this.singletonModuleNameIf(this.isPackage(qualifiedPackageName, moduleName));
    }

    public boolean hasModule() {
        return this.getModule() != null;
    }

    public abstract boolean hasCompilationUnit(String var1, String var2);

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule getModule() {
        return this.module;
    }

    protected boolean areAllModuleOptionsEqual(ClasspathLocation other) {
        if (this.patchModuleName != null) {
            if (other.patchModuleName == null) {
                return false;
            }
            if (!this.patchModuleName.equals(other.patchModuleName)) {
                return false;
            }
        } else if (other.patchModuleName != null) {
            return false;
        }
        if (this.limitModuleNames != null) {
            if (other.limitModuleNames == null) {
                return false;
            }
            if (other.limitModuleNames.size() != this.limitModuleNames.size()) {
                return false;
            }
            if (!this.limitModuleNames.containsAll(other.limitModuleNames)) {
                return false;
            }
        } else if (other.limitModuleNames != null) {
            return false;
        }
        if (this.updates != null) {
            if (other.updates == null) {
                return false;
            }
            List<Consumer<IUpdatableModule>> packageUpdates = this.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
            List<Consumer<IUpdatableModule>> otherPackageUpdates = other.updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
            if (packageUpdates != null) {
                if (otherPackageUpdates == null) {
                    return false;
                }
                if (packageUpdates.size() != otherPackageUpdates.size()) {
                    return false;
                }
                if (!packageUpdates.containsAll(otherPackageUpdates)) {
                    return false;
                }
            } else if (otherPackageUpdates != null) {
                return false;
            }
            List<Consumer<IUpdatableModule>> moduleUpdates = this.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
            List<Consumer<IUpdatableModule>> otherModuleUpdates = other.updates.getList(IUpdatableModule.UpdateKind.MODULE, false);
            if (moduleUpdates != null) {
                if (otherModuleUpdates == null) {
                    return false;
                }
                if (moduleUpdates.size() != otherModuleUpdates.size()) {
                    return false;
                }
                if (!moduleUpdates.containsAll(otherModuleUpdates)) {
                    return false;
                }
            } else if (otherModuleUpdates != null) {
                return false;
            }
        } else if (other.updates != null) {
            return false;
        }
        return true;
    }

    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, inclusionPatterns, exclusionPatterns, ignoreOptionalProblems);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean autoModule) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder, accessRuleSet, externalAnnotationPath, autoModule);
    }

    static ClasspathLocation forLibrary(String libraryPathname, long lastModified, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule, String compliance) {
        return Util.archiveFormat(libraryPathname) == 1 ? new ClasspathJMod(libraryPathname, lastModified, accessRuleSet, annotationsPath) : (compliance == null || CompilerOptions.versionToJdkLevel(compliance) < 0x350000L ? new ClasspathJar(libraryPathname, lastModified, accessRuleSet, annotationsPath, autoModule) : new ClasspathMultiReleaseJar(libraryPathname, lastModified, accessRuleSet, annotationsPath, autoModule, compliance));
    }

    public static ClasspathJrt forJrtSystem(String jrtPath, AccessRuleSet accessRuleSet, IPath annotationsPath, String release) throws CoreException {
        return release == null || release.equals("") ? new ClasspathJrt(jrtPath, accessRuleSet, annotationsPath) : new ClasspathJrtWithReleaseOption(jrtPath, accessRuleSet, annotationsPath, release);
    }

    public static ClasspathLocation forLibrary(String libraryPathname, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule, String compliance) {
        return ClasspathLocation.forLibrary(libraryPathname, 0L, accessRuleSet, annotationsPath, autoModule, compliance);
    }

    static ClasspathLocation forLibrary(IFile library, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule, String compliance) {
        return CompilerOptions.versionToJdkLevel(compliance) < 0x350000L ? new ClasspathJar(library, accessRuleSet, annotationsPath, autoModule) : new ClasspathMultiReleaseJar(library, accessRuleSet, annotationsPath, autoModule, compliance);
    }

    public static ClasspathLocation forLibrary(ZipFile zipFile, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean isOnModulePath, String compliance) {
        return CompilerOptions.versionToJdkLevel(compliance) < 0x350000L ? new ClasspathJar(zipFile, accessRuleSet, externalAnnotationPath, isOnModulePath) : new ClasspathMultiReleaseJar(zipFile, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
    }

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public void cleanup() {
    }

    public void reset() {
    }

    public abstract String debugPathString();

    public char[][] singletonModuleNameIf(boolean condition) {
        if (!condition) {
            return null;
        }
        if (this.module != null) {
            return new char[][]{this.module.name()};
        }
        return new char[][]{ModuleBinding.UNNAMED};
    }
}

