/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VerifyStyleType implements Enumerator
{
    ALL(0, "ALL", "All"),
    IGNORE_STYLES(1, "IGNORE_STYLES", "Ignore Styles"),
    IGNORE_STYLED_TEXT(2, "IGNORE_STYLED_TEXT", "Ignore Styled Text");

    public static final int ALL_VALUE = 0;
    public static final int IGNORE_STYLES_VALUE = 1;
    public static final int IGNORE_STYLED_TEXT_VALUE = 2;
    private static final VerifyStyleType[] VALUES_ARRAY;
    public static final List<VerifyStyleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VerifyStyleType[]{ALL, IGNORE_STYLES, IGNORE_STYLED_TEXT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VerifyStyleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerifyStyleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerifyStyleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VerifyStyleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VerifyStyleType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return IGNORE_STYLES;
            }
            case 2: {
                return IGNORE_STYLED_TEXT;
            }
        }
        return null;
    }

    private VerifyStyleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

