/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.dependencies;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.ui.views.dependencies.CalleesContentProvider;
import org.eclipse.pde.internal.ui.views.dependencies.DependenciesView;

public class CalleesListContentProvider
extends CalleesContentProvider
implements IStructuredContentProvider {
    boolean fShowOptional;

    public CalleesListContentProvider(DependenciesView view) {
        super(view);
    }

    public void setShowOptional(boolean showOptional) {
        this.fShowOptional = showOptional;
    }

    public boolean getShowOptional() {
        return this.fShowOptional;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IPluginModelBase) {
            LinkedHashMap elements = new LinkedHashMap();
            HashSet candidates = new LinkedHashSet<Object>();
            candidates.addAll(Arrays.asList(this.findCallees((IPluginModelBase)inputElement)));
            while (!candidates.isEmpty()) {
                HashSet<Object> newCandidates = new HashSet<Object>();
                Iterator it = candidates.iterator();
                while (it.hasNext()) {
                    Object candidate = it.next();
                    BundleDescription desc = null;
                    it.remove();
                    if (candidate instanceof BundleSpecification) {
                        if (!this.fShowOptional && ((BundleSpecification)candidate).isOptional()) continue;
                        desc = (BundleDescription)((BundleSpecification)candidate).getSupplier();
                        if (desc == null) {
                            elements.put(((BundleSpecification)candidate).getName(), candidate);
                        }
                    } else if (candidate instanceof BundleDescription) {
                        desc = (BundleDescription)candidate;
                    } else if (candidate instanceof ImportPackageSpecification) {
                        if (!this.fShowOptional && "optional".equals(((ImportPackageSpecification)candidate).getDirective("resolution"))) continue;
                        desc = ((ExportPackageDescription)((ImportPackageSpecification)candidate).getSupplier()).getExporter();
                    }
                    if (desc == null) continue;
                    IPluginModelBase callee = PluginRegistry.findModel((String)desc.getSymbolicName());
                    if (elements.containsKey(desc.getSymbolicName())) continue;
                    elements.put(desc.getSymbolicName(), candidate);
                    if (callee == null) continue;
                    newCandidates.addAll(Arrays.asList(this.findCallees(desc)));
                }
                candidates = newCandidates;
            }
            return elements.values().toArray();
        }
        return new Object[0];
    }
}

