/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.subsystem.sftp;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.apache.sshd.common.util.SshdEventListener;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import org.apache.sshd.server.subsystem.sftp.FileHandle;
import org.apache.sshd.server.subsystem.sftp.Handle;

public interface SftpEventListener
extends SshdEventListener {
    default public void initialized(ServerSession session, int version) {
    }

    default public void destroying(ServerSession session) {
    }

    default public void opening(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
    }

    default public void open(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
    }

    default public void openFailed(ServerSession session, String remotePath, Path localPath, boolean isDirectory, Throwable thrown) throws IOException {
    }

    default public void read(ServerSession session, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries) throws IOException {
    }

    default public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
    }

    default public void read(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, int readLen, Throwable thrown) throws IOException {
    }

    default public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
    }

    default public void written(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, Throwable thrown) throws IOException {
    }

    default public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
    }

    default public void blocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) throws IOException {
    }

    default public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
    }

    default public void unblocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, Throwable thrown) throws IOException {
    }

    default public void closing(ServerSession session, String remoteHandle, Handle localHandle) {
    }

    default public void closed(ServerSession session, String remoteHandle, Handle localHandle, Throwable thrown) {
    }

    default public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
    }

    default public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
    }

    default public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
    }

    default public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
    }

    default public void removing(ServerSession session, Path path) throws IOException {
    }

    default public void removed(ServerSession session, Path path, Throwable thrown) throws IOException {
    }

    default public void linking(ServerSession session, Path source, Path target, boolean symLink) throws IOException {
    }

    default public void linked(ServerSession session, Path source, Path target, boolean symLink, Throwable thrown) throws IOException {
    }

    default public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
    }

    default public void modifiedAttributes(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
    }

    public static <L extends SftpEventListener> L validateListener(L listener) {
        return (L)((SftpEventListener)SshdEventListener.validateListener(listener, (String)SftpEventListener.class.getSimpleName()));
    }
}

