/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh;

import java.util.function.Predicate;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class OpenSSHParserContext {
    public static final String NONE_CIPHER = "none";
    public static final Predicate<String> IS_NONE_CIPHER = c -> GenericUtils.isEmpty(c) || "none".equalsIgnoreCase((String)c);
    public static final String NONE_KDF = "none";
    public static final Predicate<String> IS_NONE_KDF = c -> GenericUtils.isEmpty(c) || "none".equalsIgnoreCase((String)c);
    private String cipherName;
    private String kdfName;
    private byte[] kdfOptions;

    public OpenSSHParserContext() {
    }

    public OpenSSHParserContext(String cipherName, String kdfName, byte ... kdfOptions) {
        this.cipherName = cipherName;
        this.kdfName = kdfName;
        this.kdfOptions = kdfOptions;
    }

    public String getCipherName() {
        return this.cipherName;
    }

    public void setCipherName(String cipherName) {
        this.cipherName = cipherName;
    }

    public String getKdfName() {
        return this.kdfName;
    }

    public void setKdfName(String kdfName) {
        this.kdfName = kdfName;
    }

    public byte[] getKdfOptions() {
        return this.kdfOptions;
    }

    public void setKdfOptions(byte[] kdfOptions) {
        this.kdfOptions = kdfOptions;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[cipher=" + this.getCipherName() + ", kdfName=" + this.getKdfName() + ", kdfOptions=" + BufferUtils.toHex(':', this.getKdfOptions()) + "]";
    }
}

