/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class ConfigureGerritAfterCloneTask
implements CloneOperation.PostCloneTask {
    private static final String GIT_ECLIPSE_ORG = "git.eclipse.org";
    private static final String GERRIT_CONTEXT_ROOT = "/r/";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String SSH = "ssh";
    private static final String GERRIT_CONFIG_SERVER_VERSION_API = "/config/server/version";
    private static final int GERRIT_SSHD_DEFAULT_PORT = 29418;
    private static final String GERRIT_SSHD_VERSION_API = "gerrit version";
    private static final Pattern GERRIT_SSHD_REPLY = Pattern.compile("gerrit version\\s+(?:\\d+(?:\\.\\d+)+|.+-\\d+-.*)");
    private static final String GERRIT_XSSI_MAGIC_STRING = ")]}'\n";
    private final String uri;
    private final String remoteName;
    private final CredentialsProvider credentialsProvider;
    private int timeout;

    public ConfigureGerritAfterCloneTask(String uri, String remoteName, CredentialsProvider credentialsProvider, int timeout) {
        this.uri = uri;
        this.remoteName = remoteName;
        this.timeout = timeout;
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public void execute(Repository repository, IProgressMonitor monitor) throws CoreException {
        try {
            if (this.isGerrit(repository)) {
                Activator.logInfo(String.valueOf(this.uri) + " was detected to be hosted by a Gerrit server");
                this.configureGerrit(repository);
            }
        }
        catch (Exception e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isGerrit(Repository repo) throws MalformedURLException, IOException, URISyntaxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK], 9[CASE], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static boolean isGerritVersion(String verString) {
        return verString != null && GERRIT_SSHD_REPLY.matcher(verString).matches();
    }

    private String readFully(InputStream inputStream, String encoding) throws IOException {
        return new String(this.readFully(inputStream), encoding);
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        return os.toByteArray();
    }

    private void configureGerrit(Repository repository) throws URISyntaxException, IOException {
        StoredConfig config = repository.getConfig();
        RemoteConfig remoteConfig = GerritUtil.findRemoteConfig((Config)config, this.remoteName);
        if (remoteConfig == null) {
            return;
        }
        GerritUtil.configurePushURI(remoteConfig, new URIish(this.uri));
        GerritUtil.configurePushRefSpec(remoteConfig, "master");
        GerritUtil.configureFetchNotes(remoteConfig);
        GerritUtil.setCreateChangeId((Config)config);
        remoteConfig.update((Config)config);
        config.save();
    }
}

