/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IPropertyChangeNotifier;
import org.eclipse.compare.internal.CompareContainer;
import org.eclipse.compare.internal.CompareEditorSelectionProvider;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareOutlinePage;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.WorkerJob;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class CompareEditor
extends EditorPart
implements IReusableEditor,
ISaveablesSource,
IPropertyChangeListener,
ISaveablesLifecycleListener {
    public static final String CONFIRM_SAVE_PROPERTY = "org.eclipse.compare.internal.CONFIRM_SAVE_PROPERTY";
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZING = 1;
    private static final int NO_DIFF = 2;
    private static final int CANCELED = 3;
    private static final int INITIALIZED = 4;
    private static final int ERROR = 5;
    private static final int STILL_INITIALIZING = 6;
    private static final int CREATING_CONTROL = 7;
    private static final int DONE = 8;
    private IActionBars fActionBars;
    private PageBook fPageBook;
    private Control fControl;
    private CompareOutlinePage fOutlinePage;
    private CompareSaveable fSaveable;
    private Control initializingPage;
    private Control emptyPage;
    private int state = 0;
    private HashSet<Saveable> knownSaveables;
    private final EditorCompareContainer fContainer = new EditorCompareContainer();

    public <T> T getAdapter(Class<T> key) {
        IEditorInput input;
        Object object;
        if (key.equals(IContentOutlinePage.class) && (object = this.getCompareConfiguration().getProperty("USE_OUTLINE_VIEW")) instanceof Boolean && ((Boolean)object).booleanValue()) {
            if (this.fOutlinePage != null) {
                if (this.fOutlinePage.getControl() != null && this.fOutlinePage.getControl().isDisposed()) {
                    this.fOutlinePage = null;
                } else {
                    return (T)((Object)this.fOutlinePage);
                }
            }
            this.fOutlinePage = new CompareOutlinePage(this);
            return (T)((Object)this.fOutlinePage);
        }
        if ((key == IShowInSource.class || key == OutlineViewerCreator.class || key == IFindReplaceTarget.class) && (input = this.getEditorInput()) != null) {
            return (T)Adapters.adapt((Object)input, key);
        }
        if (key == IEditorInput.class) {
            return (T)this.getEditorInput().getAdapter(IEditorInput.class);
        }
        if (key == ITextEditorExtension3.class) {
            return (T)Adapters.adapt((Object)this.getEditorInput(), ITextEditorExtension3.class);
        }
        return (T)super.getAdapter(key);
    }

    CompareConfiguration getCompareConfiguration() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            return ((CompareEditorInput)input).getCompareConfiguration();
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof CompareEditorInput)) {
            throw new PartInitException(Utilities.getString("CompareEditor.invalidInput"));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void setInput(IEditorInput input) {
        if (!(input instanceof CompareEditorInput)) {
            Status s = new Status(4, "org.eclipse.ui", 0, Utilities.getString("CompareEditor.invalidInput"), null);
            String title = Utilities.getString("CompareEditor.error.setinput.title");
            String msg = Utilities.getString("CompareEditor.error.setinput.message");
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)msg, (IStatus)s);
            return;
        }
        this.doSetInput(input);
        this.refreshActionBarsContributor();
    }

    public void refreshActionBarsContributor() {
        IEditorActionBarContributor actionBarContributor;
        IEditorSite editorSite = this.getEditorSite();
        if (editorSite != null && (actionBarContributor = editorSite.getActionBarContributor()) != null) {
            actionBarContributor.setActiveEditor(null);
            actionBarContributor.setActiveEditor((IEditorPart)this);
        }
    }

    private void doSetInput(IEditorInput input) {
        boolean hasResult;
        boolean hadPreviousInput;
        IEditorInput oldInput = this.getEditorInput();
        this.disconnectFromInput(oldInput);
        Point oldSize = null;
        boolean bl = hadPreviousInput = oldInput != null;
        if (hadPreviousInput) {
            Job.getJobManager().cancel((Object)this);
            if (this.fControl != null && !this.fControl.isDisposed()) {
                oldSize = this.fControl.getSize();
                if (this.emptyPage == null) {
                    this.emptyPage = new Composite((Composite)this.fPageBook, 0);
                }
                this.fPageBook.showPage(this.emptyPage);
                this.fControl.dispose();
                this.fControl = null;
            }
        }
        super.setInput(input);
        if (this.fOutlinePage != null) {
            this.fOutlinePage.reset();
        }
        CompareEditorInput cei = (CompareEditorInput)input;
        cei.setContainer(this.fContainer);
        this.setTitleImage(cei.getTitleImage());
        this.setPartName(cei.getTitle());
        this.setTitleToolTip(cei.getToolTipText());
        if (input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).addPropertyChangeListener(this);
        }
        this.setState(cei.getCompareResult() == null ? 1 : 4);
        if (this.fPageBook != null) {
            this.createCompareControl();
        }
        if (this.fControl != null && oldSize != null) {
            this.fControl.setSize(oldSize);
        }
        boolean bl2 = hasResult = cei.getCompareResult() != null;
        if (!hasResult) {
            this.initializeInBackground(cei, hadPreviousInput);
        }
        this.firePropertyChange(258);
        if (hadPreviousInput && hasResult) {
            this.registerSaveable();
        }
    }

    private void registerSaveable() {
        ISaveablesLifecycleListener lifecycleListener = (ISaveablesLifecycleListener)this.getSite().getService(ISaveablesLifecycleListener.class);
        lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 1, this.internalGetSaveables(true), false));
    }

    private void disconnectFromInput(IEditorInput oldInput) {
        if (oldInput != null) {
            if (oldInput instanceof IPropertyChangeNotifier) {
                ((IPropertyChangeNotifier)oldInput).removePropertyChangeListener(this);
            }
            if (this.knownSaveables != null && !this.knownSaveables.isEmpty()) {
                ISaveablesLifecycleListener lifecycleListener = (ISaveablesLifecycleListener)this.getSite().getService(ISaveablesLifecycleListener.class);
                lifecycleListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, this.knownSaveables.toArray(new Saveable[this.knownSaveables.size()]), false));
                this.knownSaveables.clear();
            }
        }
    }

    protected void initializeInBackground(final CompareEditorInput cei, final boolean hadPreviousInput) {
        Job job = new Job(NLS.bind((String)CompareMessages.CompareEditor_0, (Object)cei.getTitle())){

            protected IStatus run(IProgressMonitor monitor) {
                int[] newState = new int[]{5};
                try {
                    IStatus status = CompareUIPlugin.getDefault().prepareInput(cei, monitor);
                    if (status.isOK()) {
                        newState[0] = 4;
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (status.getCode() == 10000) {
                        newState[0] = 2;
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    newState[0] = 5;
                    IStatus iStatus = status;
                    return iStatus;
                }
                catch (OperationCanceledException operationCanceledException) {
                    newState[0] = 3;
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    if (monitor.isCanceled()) {
                        newState[0] = 3;
                    }
                    Display.getDefault().syncExec(() -> {
                        if (CompareEditor.this.fPageBook.isDisposed()) {
                            return;
                        }
                        if (hadPreviousInput || CompareEditor.this.knownSaveables != null && !CompareEditor.this.isAllSaveablesKnown()) {
                            CompareEditor.this.registerSaveable();
                        }
                        CompareEditor.this.setState(newState[0]);
                        CompareEditor.this.createCompareControl();
                    });
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                if (family == CompareEditor.this || family == cei) {
                    return true;
                }
                return cei.belongsTo(family);
            }
        };
        job.setUser(true);
        Utilities.schedule(job, (IWorkbenchSite)this.getSite());
    }

    public IActionBars getActionBars() {
        return this.fActionBars;
    }

    void setActionBars(IActionBars actionBars) {
        this.fActionBars = actionBars;
    }

    public void createPartControl(Composite parent) {
        parent.setData((Object)this);
        this.fPageBook = new PageBook(parent, 0);
        this.createCompareControl();
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        if (service != null) {
            service.activateContext("org.eclipse.compare.compareEditorScope");
            service.activateContext("org.eclipse.ui.textEditorScope");
        }
    }

    private void createCompareControl() {
        if (this.fPageBook.isDisposed()) {
            return;
        }
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            CompareEditorInput ci = (CompareEditorInput)input;
            if (ci.getCompareResult() == null) {
                if (this.getState() == 1) {
                    this.getSite().setSelectionProvider((ISelectionProvider)new CompareEditorSelectionProvider());
                    this.setPageLater();
                } else if (this.getState() == 6) {
                    if (this.initializingPage == null) {
                        this.initializingPage = this.getInitializingMessagePane((Composite)this.fPageBook);
                    }
                    this.fPageBook.showPage(this.initializingPage);
                } else if (this.getState() == 3) {
                    this.closeEditor();
                } else if (this.getState() == 2) {
                    this.setState(8);
                    this.closeEditor();
                    CompareUIPlugin.getDefault().handleNoDifference();
                } else if (this.getState() == 5) {
                    this.closeEditor();
                }
            } else if (this.fControl == null && this.getState() != 7) {
                block20: {
                    if (this.getState() == 3) {
                        this.closeEditor();
                        return;
                    }
                    this.setState(7);
                    if (this.getSite().getSelectionProvider() == null) {
                        this.getSite().setSelectionProvider((ISelectionProvider)new CompareEditorSelectionProvider());
                    }
                    try {
                        this.fControl = ci.createContents((Composite)this.fPageBook);
                    }
                    catch (SWTException e) {
                        if (e.code != 24) break block20;
                        this.setState(3);
                        return;
                    }
                }
                this.fPageBook.showPage(this.fControl);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fControl, "org.eclipse.compare.compare_editor_context");
                if (this.isActive()) {
                    this.setFocus();
                }
                this.setState(4);
            }
        }
    }

    private boolean isActive() {
        return this.getSite().getPage().getActivePart() == this;
    }

    private void setPageLater() {
        Display.getCurrent().timerExec(1000, () -> {
            CompareEditor compareEditor = this;
            synchronized (compareEditor) {
                if (this.getState() == 1) {
                    this.setState(6);
                    this.createCompareControl();
                }
            }
        });
    }

    public void dispose() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IPropertyChangeNotifier) {
            ((IPropertyChangeNotifier)input).removePropertyChangeListener(this);
        }
        super.dispose();
    }

    public void setFocus() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput && !((CompareEditorInput)input).setFocus2()) {
            this.fPageBook.setFocus();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        Assert.isTrue((boolean)false);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final IEditorInput input = this.getEditorInput();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor pm) throws CoreException {
                if (input instanceof CompareEditorInput) {
                    ((CompareEditorInput)input).saveChanges(pm);
                }
            }
        };
        Shell shell = this.getSite().getShell();
        try {
            operation.run(progressMonitor);
            this.firePropertyChange(257);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException x) {
            String title = Utilities.getString("CompareEditor.saveError.title");
            String reason = x.getTargetException().getMessage();
            MessageDialog.openError((Shell)shell, (String)title, (String)Utilities.getFormattedString("CompareEditor.cantSaveError", reason));
        }
    }

    public boolean isDirty() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof CompareEditorInput) {
            return ((CompareEditorInput)input).isDirty();
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("DIRTY_STATE")) {
            Object old_value = event.getOldValue();
            Object new_value = event.getNewValue();
            if (old_value == null || new_value == null || !old_value.equals(new_value)) {
                this.firePropertyChange(257);
            }
        } else if (event.getProperty().equals(CompareEditorInput.PROP_TITLE)) {
            this.setPartName(((CompareEditorInput)this.getEditorInput()).getTitle());
            this.setTitleToolTip(((CompareEditorInput)this.getEditorInput()).getToolTipText());
        } else if (event.getProperty().equals(CompareEditorInput.PROP_TITLE_IMAGE)) {
            this.setTitleImage(((CompareEditorInput)this.getEditorInput()).getTitleImage());
        }
    }

    public Saveable[] getSaveables() {
        return this.internalGetSaveables(this.knownSaveables == null);
    }

    private Saveable[] internalGetSaveables(boolean init) {
        IEditorInput input = this.getEditorInput();
        Saveable[] sourceSaveables = this.getSaveables(input);
        if (init || this.knownSaveables == null) {
            this.recordSaveables(sourceSaveables);
        } else {
            int i = 0;
            while (i < sourceSaveables.length) {
                Saveable saveable = sourceSaveables[i];
                if (!this.knownSaveables.contains(saveable)) {
                    CompareUIPlugin.logErrorMessage(NLS.bind((String)"Saveable {0} was not added using a saveables lifecycle event.", (Object)saveable.getName()));
                    this.knownSaveables.add(saveable);
                }
                ++i;
            }
            if (sourceSaveables.length != this.knownSaveables.size()) {
                CompareUIPlugin.logErrorMessage("Saveables were removed without an appropriate event");
                this.knownSaveables.clear();
                this.recordSaveables(sourceSaveables);
            }
        }
        return sourceSaveables;
    }

    private boolean isAllSaveablesKnown() {
        IEditorInput input = this.getEditorInput();
        Saveable[] sourceSaveables = this.getSaveables(input);
        if (this.knownSaveables == null) {
            return sourceSaveables.length == 0;
        }
        if (sourceSaveables.length != this.knownSaveables.size()) {
            return false;
        }
        int i = 0;
        while (i < sourceSaveables.length) {
            Saveable saveable = sourceSaveables[i];
            if (!this.knownSaveables.contains(saveable)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void recordSaveables(Saveable[] sourceSaveables) {
        if (this.knownSaveables == null) {
            this.knownSaveables = new HashSet();
        }
        Collections.addAll(this.knownSaveables, sourceSaveables);
    }

    private Saveable[] getSaveables(IEditorInput input) {
        if (input instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)input;
            return source.getSaveables();
        }
        return new Saveable[]{this.getSaveable()};
    }

    private Saveable getSaveable() {
        if (this.fSaveable == null) {
            this.fSaveable = new CompareSaveable();
        }
        return this.fSaveable;
    }

    public Saveable[] getActiveSaveables() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)input;
            return source.getActiveSaveables();
        }
        return new Saveable[]{this.getSaveable()};
    }

    private Composite getInitializingMessagePane(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor(parent));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        this.createDescriptionLabel(composite, CompareMessages.CompareEditor_1);
        return composite;
    }

    private Color getBackgroundColor(Composite parent) {
        return parent.getDisplay().getSystemColor(25);
    }

    private Label createDescriptionLabel(Composite parent, String text) {
        Label description = new Label(parent, 64);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        description.setLayoutData((Object)data);
        description.setText(text);
        description.setBackground(this.getBackgroundColor(parent));
        return description;
    }

    private void closeEditor() {
        this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    private synchronized void setState(int state) {
        this.state = state;
    }

    private int getState() {
        return this.state;
    }

    public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
        ISaveablesLifecycleListener lifecycleListener = (ISaveablesLifecycleListener)this.getSite().getService(ISaveablesLifecycleListener.class);
        if (event.getEventType() == 3) {
            if (this.knownSaveables == null || this.knownSaveables.isEmpty()) {
                return;
            }
            ArrayList<Saveable> result = new ArrayList<Saveable>();
            Saveable[] all = event.getSaveables();
            int i = 0;
            while (i < all.length) {
                Saveable saveable = all[i];
                if (this.knownSaveables.contains(saveable)) {
                    result.add(saveable);
                }
                this.knownSaveables.remove(saveable);
                ++i;
            }
            if (result.isEmpty()) {
                return;
            }
            event = new SaveablesLifecycleEvent((Object)this, 3, result.toArray(new Saveable[result.size()]), false);
        } else if (event.getEventType() == 1) {
            this.recordSaveables(event.getSaveables());
        }
        lifecycleListener.handleLifecycleEvent(event);
    }

    private class CompareSaveable
    extends Saveable {
        private CompareSaveable() {
        }

        public String getName() {
            return CompareEditor.this.getPartName();
        }

        public String getToolTipText() {
            return CompareEditor.this.getTitleToolTip();
        }

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromImage((Image)CompareEditor.this.getTitleImage());
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            CompareEditor.this.doSave(monitor);
        }

        public boolean isDirty() {
            return CompareEditor.this.isDirty();
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int hashCode() {
            return ((Object)((Object)CompareEditor.this)).hashCode();
        }
    }

    private class EditorCompareContainer
    extends CompareContainer {
        private EditorCompareContainer() {
        }

        @Override
        public void registerContextMenu(MenuManager menu, ISelectionProvider provider) {
            if (CompareEditor.this.getSite() instanceof IEditorSite) {
                IEditorSite es = (IEditorSite)CompareEditor.this.getSite();
                es.registerContextMenu(menu, provider, true);
            }
        }

        @Override
        public void setStatusMessage(String message) {
            IStatusLineManager slm;
            if (CompareEditor.this.fActionBars != null && (slm = CompareEditor.this.fActionBars.getStatusLineManager()) != null) {
                slm.setMessage(message);
            }
        }

        @Override
        public IServiceLocator getServiceLocator() {
            return CompareEditor.this.getSite();
        }

        @Override
        protected WorkerJob createWorkerJob() {
            WorkerJob workerJob = new WorkerJob(this.getWorkerJobName()){

                public boolean belongsTo(Object family) {
                    if (family == CompareEditor.this) {
                        return true;
                    }
                    return super.belongsTo(family);
                }
            };
            return workerJob;
        }

        @Override
        protected String getWorkerJobName() {
            return NLS.bind((String)CompareMessages.CompareEditor_2, (Object)CompareEditor.this.getTitle());
        }

        @Override
        public IWorkbenchPart getWorkbenchPart() {
            return CompareEditor.this;
        }

        @Override
        public IActionBars getActionBars() {
            return CompareEditor.this.getActionBars();
        }
    }
}

