/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.selection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.revision.FileRevisionEditorInput;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.services.IServiceLocator;

public class SelectionUtils {
    @Nullable
    public static Repository getRepository(@NonNull IStructuredSelection selection) {
        return SelectionUtils.getRepository(false, selection, null);
    }

    @NonNull
    public static Repository[] getRepositories(@Nullable IEvaluationContext evaluationContext) {
        return SelectionUtils.getRepositories(SelectionUtils.getSelection(evaluationContext));
    }

    @NonNull
    public static Repository[] getRepositories(@NonNull IStructuredSelection selection) {
        IProject[] selectedProjects = SelectionUtils.getSelectedProjects(selection);
        if (selectedProjects.length > 0) {
            return SelectionUtils.getRepositoriesFor(selectedProjects);
        }
        if (selection.isEmpty()) {
            return new Repository[0];
        }
        LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Repository repo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
            if (repo == null) {
                return new Repository[0];
            }
            repos.add(repo);
            ++n2;
        }
        return repos.toArray(new Repository[0]);
    }

    @Nullable
    public static Repository getRepository(@Nullable IEvaluationContext evaluationContext) {
        return SelectionUtils.getRepository(false, SelectionUtils.getSelection(evaluationContext), null);
    }

    @Nullable
    public static Repository getRepositoryOrWarn(@NonNull IStructuredSelection selection, @NonNull Shell shell) {
        return SelectionUtils.getRepository(true, selection, shell);
    }

    @NonNull
    public static IStructuredSelection getSelection(@Nullable IEvaluationContext context) {
        if (context == null) {
            return StructuredSelection.EMPTY;
        }
        Object selection = context.getVariable("activeMenuSelection");
        if (!(selection instanceof ISelection)) {
            selection = context.getVariable("selection");
        }
        if (selection instanceof ITextSelection) {
            return SelectionUtils.getSelectionFromEditorInput(context);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    @NonNull
    public static IStructuredSelection getStructuredSelection(@NonNull ISelection selection) {
        if (selection instanceof ITextSelection) {
            IEvaluationContext evaluationContext = SelectionUtils.getEvaluationContext();
            if (evaluationContext == null) {
                return StructuredSelection.EMPTY;
            }
            return SelectionUtils.getSelectionFromEditorInput(evaluationContext);
        }
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    @NonNull
    public static IPath[] getSelectedLocations(@NonNull IStructuredSelection selection) {
        LinkedHashSet<IPath> result = new LinkedHashSet<IPath>();
        for (Object o : selection.toList()) {
            IPath location;
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                location = resource.getLocation();
                if (location == null) continue;
                result.add(location);
                continue;
            }
            location = (IPath)AdapterUtils.adapt(o, IPath.class);
            if (location != null) {
                result.add(location);
                continue;
            }
            for (IResource r : SelectionUtils.extractResourcesFromMapping(o)) {
                IPath l = r.getLocation();
                if (l == null) continue;
                result.add(l);
            }
        }
        return result.toArray(new IPath[0]);
    }

    @NonNull
    public static IResource[] getSelectedResources(@NonNull IStructuredSelection selection) {
        Set<IResource> result = SelectionUtils.getSelectedResourcesSet(selection);
        return result.toArray(new IResource[0]);
    }

    @NonNull
    private static Set<IResource> getSelectedResourcesSet(@NonNull IStructuredSelection selection) {
        LinkedHashSet<IResource> result = new LinkedHashSet<IResource>();
        for (Object o : selection.toList()) {
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            result.addAll(SelectionUtils.extractResourcesFromMapping(o));
        }
        return result;
    }

    private static List<IResource> extractResourcesFromMapping(Object o) {
        ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt((Object)o, ResourceMapping.class);
        return ResourceUtil.extractResourcesFromMapping((ResourceMapping)mapping);
    }

    @Nullable
    public static HistoryPageInput getMostFittingInput(@NonNull IStructuredSelection selection, Object mandatoryObject) {
        Set<IResource> resources = SelectionUtils.getSelectedResourcesSet(selection);
        if (!resources.contains(mandatoryObject)) {
            return null;
        }
        Repository repository = ResourceUtil.getRepository((IResource)((IResource)mandatoryObject));
        if (repository == null) {
            return null;
        }
        Iterator<IResource> it = resources.iterator();
        while (it.hasNext()) {
            IResource resource = it.next();
            if (ResourceUtil.getRepository((IResource)resource) == repository) continue;
            it.remove();
        }
        IResource[] resourceArray = resources.toArray(new IResource[0]);
        return new HistoryPageInput(repository, resourceArray);
    }

    @NonNull
    private static Set<Object> getSelectionContents(@NonNull IStructuredSelection selection) {
        HashSet<Object> result = new HashSet<Object>();
        for (Object o : selection.toList()) {
            Repository r = (Repository)AdapterUtils.adapt(o, Repository.class);
            if (r != null) {
                result.add(r);
                continue;
            }
            IResource resource = AdapterUtils.adaptToAnyResource(o);
            if (resource != null) {
                result.add(resource);
                continue;
            }
            ResourceMapping mapping = (ResourceMapping)AdapterUtils.adapt(o, ResourceMapping.class);
            if (mapping != null) {
                result.addAll(SelectionUtils.extractResourcesFromMapping(mapping));
                continue;
            }
            IPath location = (IPath)AdapterUtils.adapt(o, IPath.class);
            if (location == null) continue;
            result.add(location);
        }
        return result;
    }

    @Nullable
    private static Repository getRepository(boolean warn, @NonNull IStructuredSelection selection, Shell shell) {
        if (selection.isEmpty()) {
            return null;
        }
        Set<Object> elements = SelectionUtils.getSelectionContents(selection);
        if (GitTraceLocation.SELECTION.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.SELECTION.getLocation(), "selection=" + selection + ", elements=" + elements.toString());
        }
        boolean hadNull = false;
        Repository result = null;
        for (Object location : elements) {
            boolean mismatch;
            Repository repo = null;
            if (location instanceof Repository) {
                repo = (Repository)location;
            } else if (location instanceof IResource) {
                repo = ResourceUtil.getRepository((IResource)((IResource)location));
            } else if (location instanceof IPath) {
                repo = ResourceUtil.getRepository((IPath)((IPath)location));
            }
            if (repo == null) {
                hadNull = true;
            }
            if (result == null) {
                result = repo;
            }
            boolean bl = mismatch = hadNull && result != null;
            if (!mismatch && result == repo) continue;
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
            }
            return null;
        }
        if (result == null) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                Repository nextRepo = (Repository)AdapterUtils.adapt((Object)o, Repository.class);
                if (nextRepo != null && result != null && result != nextRepo) {
                    if (warn) {
                        MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_multiRepoSelectionTitle, (String)UIText.RepositoryAction_multiRepoSelection);
                    }
                    return null;
                }
                result = nextRepo;
                ++n2;
            }
        }
        if (result == null) {
            if (warn) {
                MessageDialog.openError((Shell)shell, (String)UIText.RepositoryAction_errorFindingRepoTitle, (String)UIText.RepositoryAction_errorFindingRepo);
            }
            return null;
        }
        return result;
    }

    private static IStructuredSelection getSelectionFromEditorInput(IEvaluationContext context) {
        Object nestedEditor;
        Object part = context.getVariable("activePart");
        if (!(part instanceof IEditorPart)) {
            return StructuredSelection.EMPTY;
        }
        Object object = context.getVariable("activeEditorInput");
        Object editor = context.getVariable("activeEditor");
        if (editor instanceof MultiPageEditorPart && (nestedEditor = ((MultiPageEditorPart)editor).getSelectedPage()) instanceof IEditorPart) {
            object = ((IEditorPart)nestedEditor).getEditorInput();
        }
        if (!(object instanceof IEditorInput) && editor instanceof IEditorPart) {
            object = ((IEditorPart)editor).getEditorInput();
        }
        if (object instanceof IEditorInput) {
            FileRevisionEditorInput fileRevisionEditorInput;
            IFileRevision fileRevision;
            IEditorInput editorInput = (IEditorInput)object;
            IResource resource = org.eclipse.ui.ide.ResourceUtil.getResource((IEditorInput)editorInput);
            if (resource != null) {
                return new StructuredSelection((Object)resource);
            }
            if (editorInput instanceof FileRevisionEditorInput && (fileRevision = (fileRevisionEditorInput = (FileRevisionEditorInput)editorInput).getFileRevision()) != null) {
                return new StructuredSelection((Object)fileRevision);
            }
        }
        return StructuredSelection.EMPTY;
    }

    private static IEvaluationContext getEvaluationContext() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IHandlerService hsr = CommonUtils.getService((IServiceLocator)activeWorkbenchWindow, IHandlerService.class);
        IEvaluationContext ctx = hsr.getCurrentState();
        return ctx;
    }

    public static IProject[] getSelectedProjects(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (IResource resource : SelectionUtils.getSelectedAdaptables((ISelection)selection, IResource.class)) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null && mapping.getContainer() instanceof IProject) {
                ret.add((IProject)mapping.getContainer());
                continue;
            }
            return new IProject[0];
        }
        ret.addAll(SelectionUtils.extractProjectsFromMappings(selection));
        return ret.toArray(new IProject[0]);
    }

    private static Set<IProject> extractProjectsFromMappings(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (ResourceMapping mapping : SelectionUtils.getSelectedAdaptables((ISelection)selection, ResourceMapping.class)) {
            IProject[] mappedProjects = mapping.getProjects();
            if (mappedProjects == null || mappedProjects.length == 0) continue;
            ArrayList<IProject> projects = new ArrayList<IProject>(Arrays.asList(mappedProjects));
            Collections.sort(projects, CommonUtils.RESOURCE_NAME_COMPARATOR);
            ret.addAll(projects);
        }
        return ret;
    }

    @NonNull
    private static <T> List<T> getSelectedAdaptables(ISelection selection, Class<T> c) {
        List result;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = AdapterUtils.adapt(elements.next(), c);
                if (adapter == null) continue;
                result.add(adapter);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    @NonNull
    private static Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
            ++n2;
        }
        return ret.toArray(new Repository[0]);
    }
}

