/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.parts.FormBrowser;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.ui.templates.ITemplateSection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TemplateSelectionPage
extends WizardPage {
    private ITemplateSection[] fCandidates;
    private ArrayList<WizardPage> fVisiblePages;
    private WizardCheckboxTablePart fTablePart;
    private FormBrowser fDescriptionBrowser;

    public TemplateSelectionPage(ITemplateSection[] candidates) {
        super("templateSelection");
        this.fCandidates = candidates;
        this.setTitle(PDEUIMessages.TemplateSelectionPage_title);
        this.setDescription(PDEUIMessages.TemplateSelectionPage_desc);
        this.initializeTemplates();
    }

    private void initializeTemplates() {
        this.fTablePart = new TablePart(PDEUIMessages.TemplateSelectionPage_table);
        this.fDescriptionBrowser = new FormBrowser(2560);
        this.fDescriptionBrowser.setText("");
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fVisiblePages = new ArrayList();
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.fTablePart.createControl(container);
        CheckboxTableViewer viewer = this.fTablePart.getTableViewer();
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.initializeTable(viewer.getTable());
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection sel = event.getStructuredSelection();
            this.handleSelectionChanged((ITemplateSection)sel.getFirstElement());
        });
        this.fDescriptionBrowser.createControl(container);
        Control c = this.fDescriptionBrowser.getControl();
        GridData gd = new GridData(1296);
        gd.heightHint = 100;
        c.setLayoutData((Object)gd);
        viewer.setInput((Object)PDEPlugin.getDefault());
        this.initializeWizardPages();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.template_selection");
    }

    private void initializeWizardPages() {
        ITemplateSection[] iTemplateSectionArray = this.fCandidates;
        int n = this.fCandidates.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateSection section = iTemplateSectionArray[n2];
            if (!section.getPagesAdded()) {
                section.addPages((Wizard)this.getWizard());
            }
            ++n2;
        }
    }

    public ITemplateSection[] getSelectedTemplates() {
        Object[] elements = this.fTablePart.getTableViewer().getCheckedElements();
        ITemplateSection[] result = new ITemplateSection[elements.length];
        System.arraycopy(elements, 0, result, 0, elements.length);
        return result;
    }

    private void initializeTable(Table table) {
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(PDEUIMessages.TemplateSelectionPage_column_name);
        column.setResizable(true);
        column = new TableColumn(table, 0);
        column.setText(PDEUIMessages.TemplateSelectionPage_column_point);
        column.setResizable(true);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        table.setLayout((Layout)layout);
    }

    private void handleSelectionChanged(ITemplateSection section) {
        String text;
        String string = text = section != null ? section.getDescription() : "";
        if (text.length() > 0) {
            text = "<p>" + text + "</p>";
        }
        this.fDescriptionBrowser.setText(text);
    }

    public boolean canFlipToNextPage() {
        if (this.fTablePart.getSelectionCount() == 0) {
            return false;
        }
        return super.canFlipToNextPage();
    }

    public IWizardPage getNextPage() {
        ITemplateSection[] sections = this.getSelectedTemplates();
        this.fVisiblePages.clear();
        ITemplateSection[] iTemplateSectionArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            ITemplateSection section = iTemplateSectionArray[n2];
            int j = 0;
            while (j < section.getPageCount()) {
                this.fVisiblePages.add(section.getPage(j));
                ++j;
            }
            ++n2;
        }
        if (!this.fVisiblePages.isEmpty()) {
            return (IWizardPage)this.fVisiblePages.get(0);
        }
        return null;
    }

    public IWizardPage getNextVisiblePage(IWizardPage page) {
        if (page == this) {
            return page.getNextPage();
        }
        int index = this.fVisiblePages.indexOf(page);
        if (index >= 0 && index < this.fVisiblePages.size() - 1) {
            return (IWizardPage)this.fVisiblePages.get(index + 1);
        }
        return null;
    }

    class ListContentProvider
    implements IStructuredContentProvider {
        ListContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return TemplateSelectionPage.this.fCandidates;
        }
    }

    class ListLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ListLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ITemplateSection section = (ITemplateSection)obj;
            if (index == 0) {
                return section.getLabel();
            }
            return section.getUsedExtensionPoint();
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXTENSION_OBJ);
            }
            return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXT_POINT_OBJ);
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        @Override
        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormToolkit toolkit) {
            return super.createStructuredViewer(parent, style | 0x10000, toolkit);
        }

        @Override
        protected void updateCounter(int amount) {
            super.updateCounter(amount);
            if (TemplateSelectionPage.this.getContainer() != null) {
                TemplateSelectionPage.this.getContainer().updateButtons();
            }
        }
    }
}

