/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rcptt.tesla.ui.IJobCollector;

public class JobCollectorExtensions {
    private static JobCollectorExtensions instance;
    private List<IJobCollector> collectors = new ArrayList<IJobCollector>();

    public JobCollectorExtensions() {
        this.inializeProcessors();
    }

    private void inializeProcessors() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.rcptt.tesla.swt.rap.jobCollector");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            try {
                IJobCollector processor = (IJobCollector)config.createExecutableExtension("class");
                this.collectors.add(processor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public static synchronized JobCollectorExtensions getDefault() {
        if (instance == null) {
            instance = new JobCollectorExtensions();
        }
        return instance;
    }

    public IJobCollector[] getCollectors() {
        return this.collectors.toArray(new IJobCollector[this.collectors.size()]);
    }
}

