/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVParserBuilder;
import au.com.bytecode.opencsv.CSVReader;
import java.io.Reader;

public class CSVReaderBuilder {
    final Reader reader;
    int skipLines = 0;
    CSVParserBuilder csvParserBuilder = new CSVParserBuilder();
    CSVParser csvParser = null;

    CSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        this.reader = reader;
    }

    CSVReaderBuilder withSkipLines(int skipLines) {
        this.skipLines = skipLines <= 0 ? 0 : skipLines;
        return this;
    }

    CSVReaderBuilder withCSVParser(CSVParser csvParser) {
        this.csvParser = csvParser;
        return this;
    }

    CSVReader build() {
        CSVParser parser = this.csvParser != null ? this.csvParser : new CSVParser();
        return new CSVReader(this.reader, this.skipLines, parser);
    }
}

