/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.rcptt.core.model.IOpenable;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.IQ7Model;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7ElementInfo;
import org.eclipse.rcptt.internal.core.model.Util;

public abstract class Q7Element
extends PlatformObject
implements IQ7Element {
    public static final IQ7Element[] NO_ELEMENTS = new IQ7Element[0];
    protected static final Object NO_INFO = new Object();
    protected Q7Element parent;

    protected Q7Element(Q7Element parent) throws IllegalArgumentException {
        this.parent = parent;
    }

    public Object getElementInfo() throws ModelException {
        return this.getElementInfo(null);
    }

    public Object getElementInfo(IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        Object info = manager.getInfo(this);
        if (info != null) {
            return info;
        }
        return this.openWhenClosed(this.createElementInfo(), monitor);
    }

    protected abstract Object createElementInfo();

    protected boolean isInWorkingCopyMode() {
        return false;
    }

    protected abstract void generateInfos(Object var1, Map<IQ7Element, Object> var2, IProgressMonitor var3) throws ModelException;

    @Override
    public IOpenable getOpenable() {
        return this.getOpenableParent();
    }

    public IOpenable getOpenableParent() {
        return (IOpenable)((Object)this.parent);
    }

    protected synchronized Object openWhenClosed(Object info, IProgressMonitor monitor) throws ModelException {
        ModelManager manager = ModelManager.getModelManager();
        boolean isWC = this.isInWorkingCopyMode();
        HashMap<IQ7Element, Object> newElements = new HashMap<IQ7Element, Object>();
        this.generateInfos(info, newElements, monitor);
        if (info == null) {
            info = newElements.get(this);
        }
        if (info == null) {
            throw this.newNotPresentException();
        }
        if (!isWC) {
            manager.putInfos(this, newElements);
        }
        Object info2 = isWC ? info : manager.getInfo(this);
        return info2;
    }

    public void close() throws ModelException {
        ModelManager.getModelManager().removeInfoAndChildren(this);
    }

    protected abstract void closing(Object var1) throws ModelException;

    @Override
    public boolean exists() {
        try {
            this.getElementInfo();
            return true;
        }
        catch (ModelException e) {
            if (e.getStatus() instanceof Q7Status && ((Q7Status)e.getStatus()).getStatusCode() == Q7Status.Q7StatusCode.NotPressent) {
                return false;
            }
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    @Override
    public IQ7Element getAncestor(IQ7Element.HandleType type) {
        IQ7Element element = this;
        while (element != null) {
            if (element.getElementType().equals((Object)type)) {
                return element;
            }
            element = element.getParent();
        }
        return null;
    }

    public ModelException newNotPresentException() {
        Q7Status status = new Q7Status(4, "Element: " + this.getPath() + " doesn't exist");
        status.setStatusCode(Q7Status.Q7StatusCode.NotPressent);
        return new ModelException(status);
    }

    @Override
    public IQ7Element getParent() {
        return this.parent;
    }

    @Override
    public IQ7Project getQ7Project() {
        IQ7Element current = this;
        do {
            if (!(current instanceof IQ7Project)) continue;
            return (IQ7Project)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public IQ7Element[] getChildren() throws ModelException {
        return this.getChildren(null);
    }

    public IQ7Element[] getChildren(IProgressMonitor monitor) throws ModelException {
        Object elementInfo = this.getElementInfo(monitor);
        if (elementInfo instanceof Q7ElementInfo) {
            return ((Q7ElementInfo)elementInfo).getChildren();
        }
        return NO_ELEMENTS;
    }

    @Override
    public IQ7Model getModel() {
        IQ7Element current = this;
        do {
            if (!(current instanceof IQ7Model)) continue;
            return (IQ7Model)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected List<IQ7Element> getChildrenOfType(IQ7Element.HandleType type) throws ModelException {
        return this.getChildrenOfType(type, null);
    }

    protected List<IQ7Element> getChildrenOfType(IQ7Element.HandleType type, IProgressMonitor monitor) throws ModelException {
        IQ7Element[] children = this.getChildren(monitor);
        int size = children.length;
        ArrayList<IQ7Element> list = new ArrayList<IQ7Element>(size);
        int i = 0;
        while (i < size) {
            IQ7Element elt = children[i];
            if (elt.getElementType().equals((Object)type)) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() throws ModelException {
        Object elementInfo = ModelManager.getModelManager().getInfo(this);
        if (elementInfo instanceof Q7ElementInfo) {
            return ((Q7ElementInfo)elementInfo).getChildren().length > 0;
        }
        return true;
    }

    @Override
    public void accept(IQ7ElementVisitor visitor) throws ModelException {
        if (visitor.visit(this)) {
            IQ7Element[] elements = this.getChildren();
            int i = 0;
            while (i < elements.length) {
                elements[i].accept(visitor);
                ++i;
            }
            visitor.endVisit(this);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.parent == null) {
            return super.equals(o);
        }
        if (o == null) {
            return false;
        }
        Q7Element other = (Q7Element)o;
        return this.getName().equals(other.getName()) && this.parent.equals(other.parent);
    }

    public int hashCode() {
        if (this.parent == null) {
            return super.hashCode();
        }
        return Util.combineHashCodes(this.getName().hashCode(), this.parent.hashCode());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.toString(0, buffer);
        return buffer.toString();
    }

    protected void toString(int tab, StringBuffer buffer) {
        Object info = this.toStringInfo(tab, buffer);
        if (tab == 0) {
            this.toStringAncestors(buffer);
        }
        this.toStringChildren(tab, buffer, info);
    }

    public Object toStringInfo(int tab, StringBuffer buffer) {
        Object info = ModelManager.getModelManager().peekAtInfo(this);
        this.toStringInfo(tab, buffer, info, true);
        return info;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    protected void toStringAncestors(StringBuffer buffer) {
        Q7Element parentElement = (Q7Element)this.getParent();
        if (parentElement != null && parentElement.getParent() != null) {
            buffer.append(" [in ");
            parentElement.toStringInfo(0, buffer, NO_INFO, false);
            parentElement.toStringAncestors(buffer);
            buffer.append("]");
        }
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.getName());
    }

    protected String tabString(int tab) {
        StringBuffer buffer = new StringBuffer();
        int i = tab;
        while (i > 0) {
            buffer.append("  ");
            --i;
        }
        return buffer.toString();
    }

    protected void toStringChildren(int tab, StringBuffer buffer, Object info) {
        if (info == null || !(info instanceof Q7ElementInfo)) {
            return;
        }
        IQ7Element[] children = ((Q7ElementInfo)info).getChildren();
        int i = 0;
        while (i < children.length) {
            buffer.append("\n");
            ((Q7Element)children[i]).toString(tab + 1, buffer);
            ++i;
        }
    }

    public String toDebugString() {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, true);
        return buffer.toString();
    }

    public String toStringWithAncestors() {
        return this.toStringWithAncestors(true);
    }

    public String toStringWithAncestors(boolean showResolvedInfo) {
        StringBuffer buffer = new StringBuffer();
        this.toStringInfo(0, buffer, NO_INFO, showResolvedInfo);
        this.toStringAncestors(buffer);
        return buffer.toString();
    }
}

