/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.e4.ui.workbench.swt.internal.copy.SearchPattern;
import org.eclipse.jface.viewers.BoldStylerProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.StyledStringHighlighter;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.FilteredTableBaseHandler;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.themes.ITheme;

public class WorkbookEditorsHandler
extends FilteredTableBaseHandler {
    private static final String ORG_ECLIPSE_E4_UI_WORKBENCH_RENDERERS_SWT = "org.eclipse.e4.ui.workbench.renderers.swt";
    private static final String ORG_ECLIPSE_UI_WINDOW_OPEN_EDITOR_DROP_DOWN = "org.eclipse.ui.window.openEditorDropDown";
    private static final String TAG_ACTIVE = "active";
    private SearchPattern searchPattern;

    private static boolean isMruEnabled() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(ORG_ECLIPSE_E4_UI_WORKBENCH_RENDERERS_SWT);
        boolean initialMRUValue = preferences.getBoolean("enableMRUDefault", true);
        return preferences.getBoolean("enableMRU", initialMRUValue);
    }

    @Override
    protected Object getInput(WorkbenchPage page) {
        return this.getParts(page);
    }

    private List<EditorReference> getParts(WorkbenchPage page) {
        List<EditorReference> refs;
        if (WorkbookEditorsHandler.isMruEnabled()) {
            refs = page.getSortedEditorReferences();
        } else {
            refs = new ArrayList<EditorReference>();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ier = iEditorReferenceArray[n2];
                refs.add((EditorReference)ier);
                ++n2;
            }
        }
        return refs;
    }

    @Override
    protected boolean isFiltered() {
        return true;
    }

    SearchPattern getMatcher() {
        return this.searchPattern;
    }

    @Override
    protected void setMatcherString(String pattern) {
        if (pattern.length() == 0) {
            this.searchPattern = null;
        } else {
            SearchPattern patternMatcher = new SearchPattern();
            if (pattern.indexOf(42) != 0 && pattern.indexOf(63) != 0) {
                pattern = String.valueOf('*') + pattern;
            }
            patternMatcher.setPattern(pattern);
            this.searchPattern = patternMatcher;
        }
    }

    @Override
    protected void setLabelProvider(TableViewerColumn tableViewerColumn) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof WorkbenchPartReference) {
                    WorkbenchPartReference ref = (WorkbenchPartReference)element;
                    String text = WorkbookEditorsHandler.this.getWorkbenchPartReferenceText(ref);
                    cell.setText(text);
                    cell.setImage(ref.getTitleImage());
                    SearchPattern matcher = WorkbookEditorsHandler.this.getMatcher();
                    if (matcher == null) {
                        cell.setStyleRanges(null);
                    } else {
                        String pattern = matcher.getPattern();
                        StyledStringHighlighter ssh = new StyledStringHighlighter();
                        StyledString ss = ssh.highlight(text, pattern, new BoldStylerProvider(WorkbookEditorsHandler.this.getFont(false, true)).getBoldStyler());
                        cell.setStyleRanges(ss.getStyleRanges());
                    }
                    cell.getControl().redraw();
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof WorkbenchPartReference) {
                    WorkbenchPartReference ref = (WorkbenchPartReference)element;
                    return ref.getTitleToolTip();
                }
                return super.getToolTipText(element);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewerColumn.getViewer());
    }

    protected boolean isActiveEditor(MPart model) {
        if (model == null || model.getTags() == null) {
            return false;
        }
        return model.getTags().contains(TAG_ACTIVE);
    }

    protected boolean isHiddenEditor(MPart model) {
        if (model == null || model.getParent() == null || !(model.getParent().getRenderer() instanceof StackRenderer)) {
            return false;
        }
        StackRenderer renderer = (StackRenderer)model.getParent().getRenderer();
        CTabItem item = renderer.findItemForPart(model);
        return item != null && !item.isShowing();
    }

    private Font getFont(boolean hidden, boolean active) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (active) {
            return theme.getFontRegistry().getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        }
        if (hidden) {
            return theme.getFontRegistry().getBold("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        }
        return theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
    }

    @Override
    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                SearchPattern matcher = WorkbookEditorsHandler.this.getMatcher();
                if (matcher == null || !(viewer instanceof TableViewer)) {
                    return true;
                }
                String matchName = null;
                if (element instanceof EditorReference && (matchName = ((EditorReference)element).getTitle()).startsWith("*")) {
                    matchName = matchName.substring(1);
                }
                if (matchName == null) {
                    return false;
                }
                return matcher.matches(matchName);
            }
        };
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        return null;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(ORG_ECLIPSE_UI_WINDOW_OPEN_EDITOR_DROP_DOWN);
        return new ParameterizedCommand(command, null);
    }

    @Override
    protected int getCurrentItemIndex() {
        if (WorkbookEditorsHandler.isMruEnabled()) {
            return 0;
        }
        WorkbenchPage page = (WorkbenchPage)this.window.getActivePage();
        List<EditorReference> sortedByUse = page.getSortedEditorReferences();
        if (sortedByUse.size() < 2) {
            return 0;
        }
        EditorReference next = sortedByUse.get(1);
        List<EditorReference> sortedByPosition = this.getParts(page);
        int i = 0;
        while (i < sortedByPosition.size()) {
            EditorReference ref = sortedByPosition.get(i);
            if (ref == next) {
                if (i > 0) {
                    this.gotoDirection = true;
                    return i - 1;
                }
                this.gotoDirection = false;
                return 1;
            }
            ++i;
        }
        return super.getCurrentItemIndex();
    }
}

