/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.iproduct.IPluginConfiguration;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductFeature;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IProductModelFactory;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PluginConfigurationSection
extends TableSection {
    private TableViewer fConfigurationsTable;
    private TableEditor fLevelColumnEditor;
    private TableEditor fAutoColumnEditor;
    private static final char VERSION_SEPARATOR = '*';

    public PluginConfigurationSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, PluginConfigurationSection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{PDEUIMessages.Product_PluginSection_add, PDEUIMessages.Product_PluginSection_recommended, PDEUIMessages.PluginSection_remove, PDEUIMessages.Product_PluginSection_removeAll};
        return labels;
    }

    private static String getBundlesWithStartLevels() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.felix.scr@2:start,");
        buffer.append("org.eclipse.core.runtime@start,");
        buffer.append("org.eclipse.equinox.common@2:start,");
        buffer.append("org.eclipse.equinox.event@2:start,");
        buffer.append("org.eclipse.equinox.simpleconfigurator@1:start,");
        return buffer.toString();
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.ConfigurationPageMock_sectionTitle);
        section.setDescription(PDEUIMessages.ConfigurationPageMock_sectionDesc);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 3, toolkit);
        this.createViewerPartControl(container, 65540, 3, toolkit);
        this.fConfigurationsTable = this.getTablePart().getTableViewer();
        final Table table = this.fConfigurationsTable.getTable();
        final TableColumn column1 = new TableColumn(table, 16384);
        column1.setText(PDEUIMessages.PluginConfigurationSection_tablePluginTitle);
        column1.setWidth(300);
        final TableColumn levelColumnEditor = new TableColumn(table, 16384);
        levelColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_levelColumn);
        final TableColumn autoColumnEditor = new TableColumn(table, 16384);
        autoColumnEditor.setText(PDEUIMessages.EquinoxPluginBlock_autoColumn);
        table.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                int size = table.getSize().x;
                column1.setWidth(size / 7 * 4);
                levelColumnEditor.setWidth(size / 7 * 2);
                autoColumnEditor.setWidth(size / 7 * 1);
            }
        });
        table.setHeaderVisible(true);
        toolkit.paintBordersFor(container);
        this.fConfigurationsTable.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fConfigurationsTable.setContentProvider((IContentProvider)new ContentProvider());
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.createEditors();
        section.setClient((Control)container);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(true, true);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleAddDefaults();
                break;
            }
            case 2: {
                this.handleRemove();
                break;
            }
            case 3: {
                this.handleRemoveAll();
            }
        }
    }

    private void handleAdd() {
        Collection<IPluginModelBase> pluginModelBases = null;
        pluginModelBases = this.getProduct().useFeatures() ? this.getPluginModelBasesByFeature() : this.getPluginModelBasesByPlugin();
        PluginSelectionDialog pluginSelectionDialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), pluginModelBases.toArray(new IPluginModelBase[pluginModelBases.size()]), true);
        if (pluginSelectionDialog.open() == 0) {
            Object[] result;
            Object[] objectArray = result = pluginSelectionDialog.getResult();
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                IPluginModelBase pluginModelBase = (IPluginModelBase)object;
                this.addPlugin(pluginModelBase.getPluginBase().getId());
                ++n2;
            }
        }
    }

    private Collection<IPluginModelBase> getPluginModelBasesByFeature() {
        IProductFeature[] features;
        ArrayList<IPluginModelBase> pluginModelBases = new ArrayList<IPluginModelBase>();
        IProductFeature[] iProductFeatureArray = features = this.getProduct().getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            IProductFeature feature = iProductFeatureArray[n2];
            FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
            IFeatureModel fModel = manager.findFeatureModelRelaxed(feature.getId(), feature.getVersion());
            if (fModel == null) {
                fModel = manager.findFeatureModel(feature.getId());
            }
            if (fModel != null) {
                IFeaturePlugin[] fPlugins;
                IFeaturePlugin[] iFeaturePluginArray = fPlugins = fModel.getFeature().getPlugins();
                int n3 = fPlugins.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase pluginModelBase;
                    IFeaturePlugin fPlugin = iFeaturePluginArray[n4];
                    if (!fPlugin.isFragment() && (pluginModelBase = PluginRegistry.findModel((String)fPlugin.getId())) != null) {
                        pluginModelBases.add(pluginModelBase);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return pluginModelBases;
    }

    private Collection<IPluginModelBase> getPluginModelBasesByPlugin() {
        ArrayList<IPluginModelBase> pluginModelBases = new ArrayList<IPluginModelBase>();
        IProductPlugin[] allPlugins = this.getProduct().getPlugins();
        IPluginConfiguration[] configs = this.getProduct().getPluginConfigurations();
        IProductPlugin[] iProductPluginArray = allPlugins;
        int n = allPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            IProductPlugin productPlugin = iProductPluginArray[n2];
            if (!this.pluginConfigurationContainsProductPlugin(configs, productPlugin) && !(PluginRegistry.findModel((String)productPlugin.getId()) instanceof IFragmentModel)) {
                IPluginModelBase pluginModelBase = PluginRegistry.findModel((String)productPlugin.getId());
                pluginModelBases.add(pluginModelBase);
            }
            ++n2;
        }
        return pluginModelBases;
    }

    private boolean pluginConfigurationContainsProductPlugin(IPluginConfiguration[] configs, IProductPlugin productPlugin) {
        IPluginConfiguration[] iPluginConfigurationArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginConfiguration pluginConfiguration = iPluginConfigurationArray[n2];
            if (productPlugin.getId().equals(pluginConfiguration.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fConfigurationsTable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            Object[] objects = ssel.toArray();
            IPluginConfiguration[] configurations = new IPluginConfiguration[objects.length];
            System.arraycopy(objects, 0, configurations, 0, objects.length);
            this.getProduct().removePluginConfigurations(configurations);
        }
        this.clearEditors();
    }

    private void handleRemoveAll() {
        IProduct product = this.getProduct();
        product.removePluginConfigurations(product.getPluginConfigurations());
        this.clearEditors();
    }

    private void handleAddDefaults() {
        StringTokenizer tok = new StringTokenizer(PluginConfigurationSection.getBundlesWithStartLevels(), ",");
        ArrayList<String[]> plugins = new ArrayList<String[]>();
        IProduct product = this.getProduct();
        while (tok.hasMoreTokens()) {
            String autostart;
            String token = tok.nextToken();
            int index = token.indexOf(64);
            if (index < 0) continue;
            String idVersion = token.substring(0, index);
            int versionIndex = idVersion.indexOf(42);
            String id = versionIndex > 0 ? idVersion.substring(0, versionIndex) : idVersion;
            int endStartLevelIndex = token.indexOf(58, index);
            String startLevel = "";
            if (endStartLevelIndex > 0) {
                startLevel = token.substring(index + 1, endStartLevelIndex);
                autostart = token.substring(endStartLevelIndex + 1);
            } else {
                autostart = token.substring(index + 1);
            }
            if (product.findPluginConfiguration(id) != null) continue;
            plugins.add(new String[]{id, startLevel, autostart});
        }
        if (!plugins.isEmpty()) {
            StringBuilder bundlesList = new StringBuilder();
            bundlesList.append('\n');
            bundlesList.append('\n');
            int i = 0;
            while (i < plugins.size()) {
                String[] config = (String[])plugins.get(i);
                bundlesList.append('\t');
                bundlesList.append(config[0]);
                bundlesList.append(", ");
                String startLevel = config[1];
                if (startLevel.length() > 0) {
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_levelColumn);
                    bundlesList.append(' ');
                    bundlesList.append(startLevel);
                } else {
                    String defaultLevelColumn = NLS.bind((String)PDEUIMessages.EquinoxPluginBlock_defaultLevelColumn, (Object)"Default");
                    bundlesList.append(defaultLevelColumn);
                }
                if ("start".equals(config[2])) {
                    bundlesList.append(", ");
                    bundlesList.append(PDEUIMessages.EquinoxPluginBlock_autoColumn);
                }
                bundlesList.append('\n');
                ++i;
            }
            bundlesList.append('\n');
            if (MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)NLS.bind((String)PDEUIMessages.Product_PluginSection_RecommendedBundles_message, (Object)bundlesList.toString()))) {
                IPluginConfiguration[] pluginConfigs = new IPluginConfiguration[plugins.size()];
                int i2 = 0;
                while (i2 < plugins.size()) {
                    IProductModelFactory factory = product.getModel().getFactory();
                    IPluginConfiguration configuration = factory.createPluginConfiguration();
                    configuration.setId(((String[])plugins.get(i2))[0]);
                    String startString = ((String[])plugins.get(i2))[1];
                    if (startString.length() > 0) {
                        configuration.setStartLevel(Integer.parseInt(startString));
                    }
                    configuration.setAutoStart("start".equals(((String[])plugins.get(i2))[2]));
                    pluginConfigs[i2] = configuration;
                    ++i2;
                }
                product.addPluginConfigurations(pluginConfigs);
                this.showControls();
            }
        } else {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.Product_PluginSection_RecommendedBundles_title, (String)PDEUIMessages.Product_PluginSection_NoRecommendedBundles_message);
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.updateRemoveButtons(true, false);
    }

    private void addPlugin(String id) {
        IProduct product = this.getProduct();
        IProductModelFactory factory = product.getModel().getFactory();
        IPluginConfiguration configuration = factory.createPluginConfiguration();
        configuration.setId(id);
        product.addPluginConfigurations(new IPluginConfiguration[]{configuration});
        this.fConfigurationsTable.setSelection((ISelection)new StructuredSelection((Object)configuration));
        this.showControls();
    }

    private ILabelProvider getLabelProvider() {
        return new LabelProvider();
    }

    private void clearEditors() {
        Control oldEditor = this.fLevelColumnEditor.getEditor();
        if (oldEditor != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
        if ((oldEditor = this.fAutoColumnEditor.getEditor()) != null && !oldEditor.isDisposed()) {
            oldEditor.dispose();
        }
    }

    private void createEditors() {
        Table table = this.fConfigurationsTable.getTable();
        this.fLevelColumnEditor = new TableEditor(table);
        this.fLevelColumnEditor.horizontalAlignment = 0x1000000;
        this.fLevelColumnEditor.minimumWidth = 40;
        this.fLevelColumnEditor.grabHorizontal = true;
        if (Util.isMac()) {
            this.fLevelColumnEditor.minimumHeight = 27;
        }
        this.fAutoColumnEditor = new TableEditor(table);
        this.fAutoColumnEditor.horizontalAlignment = 0x1000000;
        this.fAutoColumnEditor.grabHorizontal = true;
        this.fAutoColumnEditor.minimumWidth = 50;
        table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.showControls()));
    }

    private void showControls() {
        this.clearEditors();
        Table table = this.fConfigurationsTable.getTable();
        IStructuredSelection selection = this.fConfigurationsTable.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        TableItem item = table.getSelection()[0];
        if (item != null && !this.isEditable()) {
            return;
        }
        if (item != null) {
            IPluginConfiguration ppc = (IPluginConfiguration)selection.getFirstElement();
            Spinner spinner = new Spinner((Composite)table, 2048);
            spinner.setMinimum(0);
            String level = item.getText(1);
            int defaultLevel = level.length() == 0 || "default".equals(level) ? 0 : Integer.parseInt(level);
            spinner.setSelection(defaultLevel);
            spinner.addModifyListener(e -> {
                int selection1 = spinner.getSelection();
                item.setText(1, selection1 == 0 ? "default" : Integer.toString(selection1));
                ppc.setStartLevel(selection1);
            });
            this.fLevelColumnEditor.setEditor((Control)spinner, item, 1);
            CCombo combo = new CCombo((Composite)table, 2056);
            combo.setItems(new String[]{Boolean.toString(true), Boolean.toString(false)});
            combo.setText(item.getText(2));
            combo.pack();
            combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                item.setText(2, combo.getText());
                ppc.setAutoStart(Boolean.parseBoolean(combo.getText()));
            }));
            this.fAutoColumnEditor.setEditor((Control)combo, item, 2);
        }
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleGlobalRefresh();
            return;
        }
        Table table = this.fConfigurationsTable.getTable();
        int count = table.getItemCount();
        Object[] objects = e.getChangedObjects();
        boolean refreshRemove = false;
        boolean refreshRemoveAll = false;
        if (e.getChangeType() == 1) {
            if (count == 0) {
                refreshRemoveAll = true;
            }
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.add(object);
                }
                ++n2;
            }
        } else if (e.getChangeType() == 2) {
            refreshRemoveAll = true;
            refreshRemove = true;
            int index = table.getSelectionIndex();
            boolean global = false;
            Object[] objectArray = objects;
            int n = objects.length;
            int n3 = 0;
            while (n3 < n) {
                Object object = objectArray[n3];
                if (object instanceof IPluginConfiguration) {
                    this.fConfigurationsTable.remove(object);
                } else if (object instanceof IProductPlugin) {
                    global = true;
                    break;
                }
                ++n3;
            }
            if (global) {
                this.handleGlobalRefresh();
            }
            if (count == 0) {
                table.deselectAll();
                this.clearEditors();
            } else if (index < count) {
                table.setSelection(index);
            } else {
                table.setSelection(count - 1);
            }
        }
        this.getTablePart().setButtonEnabled(0, this.isEditable());
        this.updateRemoveButtons(refreshRemove, refreshRemoveAll);
    }

    private void handleGlobalRefresh() {
        this.fConfigurationsTable.setInput((Object)this.getProduct());
        this.fConfigurationsTable.refresh();
    }

    private void updateRemoveButtons(boolean updateRemove, boolean updateRemoveAll) {
        EditableTablePart tablePart = this.getTablePart();
        if (updateRemove) {
            IStructuredSelection selection = this.getViewerSelection();
            tablePart.setButtonEnabled(2, this.isEditable() && !selection.isEmpty());
        }
        int count = this.fConfigurationsTable.getTable().getItemCount();
        if (updateRemoveAll) {
            tablePart.setButtonEnabled(3, this.isEditable() && count > 0);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private IProduct fProduct;

        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fProduct.getPluginConfigurations();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput == newInput) {
                return;
            }
            this.fProduct = (IProduct)newInput;
        }
    }

    private class LabelProvider
    extends PDELabelProvider {
        private LabelProvider() {
        }

        @Override
        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return super.getColumnImage(PluginRegistry.findModel((String)((IPluginConfiguration)obj).getId()), index);
            }
            return null;
        }

        @Override
        public String getColumnText(Object obj, int index) {
            IPluginConfiguration configuration = (IPluginConfiguration)obj;
            switch (index) {
                case 0: {
                    return configuration.getId();
                }
                case 1: {
                    return configuration.getStartLevel() == 0 ? "default" : Integer.toString(configuration.getStartLevel());
                }
                case 2: {
                    return Boolean.toString(configuration.isAutoStart());
                }
            }
            return null;
        }
    }
}

