/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.CachedCheckboxTreeViewer;
import org.eclipse.egit.ui.internal.components.FilteredCheckboxTree;
import org.eclipse.egit.ui.internal.components.RemoteSelectionCombo;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.RepositoryTreeNodeLabelProvider;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.TagsNode;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PushTagsPage
extends WizardPage {
    private final Repository repository;
    private final Set<String> tagRefNamesToSelect = new HashSet<String>();
    private RemoteConfig selectedRemoteConfig = null;
    private List<TagNode> selectedTags = new ArrayList<TagNode>();
    private boolean forceUpdateSelected = false;
    private Label tagsLabel;

    public PushTagsPage(Repository repository, Collection<String> tagNamesToSelect) {
        super(UIText.PushTagsPage_PageName);
        this.setTitle(UIText.PushTagsPage_PageTitle);
        this.setMessage(UIText.PushTagsPage_PageMessage);
        this.repository = repository;
        for (String tagName : tagNamesToSelect) {
            if (tagName.startsWith("refs/tags/")) {
                this.tagRefNamesToSelect.add(tagName);
                continue;
            }
            this.tagRefNamesToSelect.add("refs/tags/" + tagName);
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().spacing(LayoutConstants.getSpacing()).numColumns(2).create());
        Label remoteLabel = new Label(main, 0);
        remoteLabel.setText(UIText.PushTagsPage_RemoteLabel);
        RemoteSelectionCombo remoteSelectionCombo = new RemoteSelectionCombo(main, 0, RemoteSelectionCombo.SelectionType.PUSH);
        remoteSelectionCombo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        this.selectedRemoteConfig = remoteSelectionCombo.setItems(this.getRemoteConfigs());
        remoteSelectionCombo.addRemoteSelectionListener(rc -> {
            this.selectedRemoteConfig = rc;
        });
        this.tagsLabel = new Label(main, 0);
        this.tagsLabel.setText(UIText.PushTagsPage_TagsLabelNoneSelected);
        this.tagsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        FilteredCheckboxTree tree = new FilteredCheckboxTree(main, null, 2048);
        tree.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).span(2, 1).hint(400, 300).create());
        final Button forceUpdateButton = new Button(main, 32);
        forceUpdateButton.setText(UIText.PushTagsPage_ForceUpdateButton);
        forceUpdateButton.setSelection(false);
        forceUpdateButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        forceUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PushTagsPage.this.forceUpdateSelected = forceUpdateButton.getSelection();
            }
        });
        final CachedCheckboxTreeViewer treeViewer = tree.getCheckboxTreeViewer();
        TagsNode tagsNode = new TagsNode(null, this.repository);
        ContentProvider contentProvider = new ContentProvider(tagsNode);
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new RepositoryTreeNodeLabelProvider());
        treeViewer.setComparator(new ViewerComparator(CommonUtils.STRING_ASCENDING_COMPARATOR));
        treeViewer.setInput(tagsNode);
        Object[] tagNodes = contentProvider.getElements(tagsNode);
        this.initiallySelectTags(tagNodes, (CheckboxTreeViewer)treeViewer);
        treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PushTagsPage.this.setSelectedTags(treeViewer.getCheckedElements());
            }
        });
        this.setControl((Control)main);
    }

    public boolean isPageComplete() {
        return this.selectedRemoteConfig != null && !this.selectedTags.isEmpty();
    }

    RemoteConfig getSelectedRemoteConfig() {
        return this.selectedRemoteConfig;
    }

    List<TagNode> getSelectedTags() {
        return this.selectedTags;
    }

    boolean isForceUpdateSelected() {
        return this.forceUpdateSelected;
    }

    private void initiallySelectTags(Object[] tagNodes, CheckboxTreeViewer viewer) {
        ArrayList<TagNode> checkedTags = new ArrayList<TagNode>();
        Object[] objectArray = tagNodes;
        int n = tagNodes.length;
        int n2 = 0;
        while (n2 < n) {
            TagNode tagNode;
            Ref ref;
            Object node = objectArray[n2];
            if (node instanceof TagNode && this.tagRefNamesToSelect.contains((ref = (Ref)(tagNode = (TagNode)node).getObject()).getName())) {
                checkedTags.add(tagNode);
            }
            ++n2;
        }
        Object[] checkedTagsArray = checkedTags.toArray(new TagNode[0]);
        viewer.setCheckedElements(checkedTagsArray);
        if (checkedTagsArray.length > 0) {
            viewer.setSelection((ISelection)new StructuredSelection(checkedTagsArray), true);
            viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.setSelectedTags(checkedTagsArray);
    }

    private void setSelectedTags(Object[] tags) {
        this.selectedTags.clear();
        Object[] objectArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            Object tag = objectArray[n2];
            if (tag instanceof TagNode) {
                this.selectedTags.add((TagNode)tag);
            }
            ++n2;
        }
        int number = this.selectedTags.size();
        if (number == 0) {
            this.tagsLabel.setText(UIText.PushTagsPage_TagsLabelNoneSelected);
        } else {
            this.tagsLabel.setText(MessageFormat.format(UIText.PushTagsPage_TagsLabelSelected, this.selectedTags.size()));
        }
        this.setPageComplete(this.isPageComplete());
    }

    private List<RemoteConfig> getRemoteConfigs() {
        try {
            return RemoteConfig.getAllRemoteConfigs((Config)this.repository.getConfig());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ContentProvider
    extends RepositoriesViewContentProvider {
        private final Object[] children;

        private ContentProvider(TagsNode tagsNode) {
            this.children = this.getChildren(tagsNode);
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return this.children;
        }
    }
}

