/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.internal.core.BundleValidationOperation;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;

public class DependencyManager {
    public static Set<String> getSelfAndDependencies(IPluginModelBase model, String[] excludeFragments) {
        return DependencyManager.getDependencies(Collections.singleton(model), DependencyManager.getImplicitDependencies(), TargetPlatformHelper.getState(), false, true, DependencyManager.toSet(excludeFragments));
    }

    public static Set<String> getSelfandDependencies(IPluginModelBase[] models, String[] excludeFragments) {
        return DependencyManager.getDependencies(DependencyManager.getPluginModels(models), DependencyManager.getImplicitDependencies(), TargetPlatformHelper.getState(), false, true, DependencyManager.toSet(excludeFragments));
    }

    public static Set<String> getDependencies(Object[] selected, String[] implicit, State state, String[] excludeFragments) {
        return DependencyManager.getDependencies(DependencyManager.getPluginModels(selected), implicit, state, true, true, DependencyManager.toSet(excludeFragments));
    }

    public static Set<String> getDependencies(Object[] selected, boolean includeOptional, String[] excludeFragments) {
        return DependencyManager.getDependencies(DependencyManager.getPluginModels(selected), DependencyManager.getImplicitDependencies(), TargetPlatformHelper.getState(), true, includeOptional, DependencyManager.toSet(excludeFragments));
    }

    private static Set<String> toSet(String[] array) {
        if (array == null || array.length == 0) {
            return Collections.emptySet();
        }
        return Arrays.stream(array).collect(Collectors.toSet());
    }

    private static Set<IPluginModelBase> getPluginModels(Object[] selected) {
        return Arrays.stream(selected).filter(IPluginModelBase.class::isInstance).map(IPluginModelBase.class::cast).collect(Collectors.toSet());
    }

    private static Set<String> getDependencies(Set<IPluginModelBase> selected, String[] implicit, State state, boolean removeSelf, boolean includeOptional, Set<String> excludeFragments) {
        TreeSet<String> bundleIds = new TreeSet<String>();
        HashSet<IPluginModelBase> models = new HashSet<IPluginModelBase>(selected);
        for (IPluginModelBase model2 : selected) {
            IPluginExtension[] extensions;
            DependencyManager.addBundleAndDependencies(model2.getBundleDescription(), bundleIds, includeOptional, excludeFragments);
            IPluginExtension[] iPluginExtensionArray = extensions = model2.getPluginBase().getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                int dot;
                IPluginExtension extension = iPluginExtensionArray[n2];
                String point = extension.getPoint();
                if (point != null && (dot = point.lastIndexOf(46)) != -1) {
                    String id = point.substring(0, dot);
                    DependencyManager.addBundleAndDependencies(state.getBundle(id, null), bundleIds, includeOptional, excludeFragments);
                }
                ++n2;
            }
        }
        String[] stringArray = implicit;
        int extensions = implicit.length;
        int n = 0;
        while (n < extensions) {
            String element = stringArray[n];
            DependencyManager.addBundleAndDependencies(state.getBundle(element, null), bundleIds, includeOptional, excludeFragments);
            ++n;
        }
        Set selectedBundleIds = selected.stream().map(model -> model.getPluginBase().getId()).collect(Collectors.toSet());
        boolean hasAdditionallySelectedBundles = bundleIds.stream().anyMatch(bundleId -> !selectedBundleIds.contains(bundleId));
        if (hasAdditionallySelectedBundles) {
            for (IPluginModelBase model3 : DependencyManager.getDependencies(TargetPlatformHelper.getState(), models.toArray(new IPluginModelBase[models.size()]))) {
                bundleIds.add(model3.getBundleDescription().getSymbolicName());
            }
            for (String id : bundleIds) {
                ModelEntry entry = PluginRegistry.findEntry(id);
                if (entry == null) continue;
                models.add(entry.getModel());
            }
            Set<String> additionalIds = DependencyManager.getDependencies(models, implicit, state, removeSelf, includeOptional, excludeFragments);
            bundleIds.addAll(additionalIds);
        }
        if (removeSelf) {
            bundleIds.removeAll(selectedBundleIds);
        }
        return bundleIds;
    }

    private static String[] getImplicitDependencies() {
        try {
            NameVersionDescriptor[] implicit;
            ITargetPlatformService service = PDECore.getDefault().acquireService(ITargetPlatformService.class);
            if (service != null && (implicit = service.getWorkspaceTargetDefinition().getImplicitDependencies()) != null) {
                String[] result = new String[implicit.length];
                int i = 0;
                while (i < implicit.length) {
                    result[i] = implicit[i].getId();
                    ++i;
                }
                return result;
            }
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        return new String[0];
    }

    private static void addBundleAndDependencies(BundleDescription desc, Set<String> set, boolean includeOptional, Set<String> excludeFragments) {
        if (desc != null && set.add(desc.getSymbolicName())) {
            ImportPackageSpecification[] importedPkgs;
            BundleSpecification[] required = desc.getRequiredBundles();
            int i = 0;
            while (i < required.length) {
                if (includeOptional || !required[i].isOptional()) {
                    DependencyManager.addBundleAndDependencies((BundleDescription)required[i].getSupplier(), set, includeOptional, excludeFragments);
                }
                ++i;
            }
            ImportPackageSpecification[] importPackageSpecificationArray = importedPkgs = desc.getImportPackages();
            int n = importedPkgs.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageSpecification importedPkg = importPackageSpecificationArray[n2];
                ExportPackageDescription exporter = (ExportPackageDescription)importedPkg.getSupplier();
                if (exporter != null && (includeOptional || !"optional".equals(importedPkg.getDirective("resolution")))) {
                    DependencyManager.addBundleAndDependencies(exporter.getExporter(), set, includeOptional, excludeFragments);
                }
                ++n2;
            }
            BundleDescription[] fragments = desc.getFragments();
            int i2 = 0;
            while (i2 < fragments.length) {
                String id;
                if (fragments[i2].isResolved() && !excludeFragments.contains(id = fragments[i2].getSymbolicName())) {
                    DependencyManager.addBundleAndDependencies(fragments[i2], set, includeOptional, excludeFragments);
                }
                ++i2;
            }
            HostSpecification host = desc.getHost();
            if (host != null) {
                DependencyManager.addBundleAndDependencies((BundleDescription)host.getSupplier(), set, includeOptional, excludeFragments);
            }
        }
    }

    private static Set<IPluginModelBase> getDependencies(State state, IPluginModelBase[] models) {
        HashSet<IPluginModelBase> dependencies = new HashSet<IPluginModelBase>();
        BundleValidationOperation operation = new BundleValidationOperation(models);
        try {
            VersionConstraint[] unsatisfiedConstraints;
            operation.run((IProgressMonitor)new NullProgressMonitor());
            Map<Object, Object[]> input = operation.getResolverErrors();
            VersionConstraint[] versionConstraintArray = unsatisfiedConstraints = (VersionConstraint[])input.values().stream().filter(ResolverError[].class::isInstance).map(ResolverError[].class::cast).flatMap(Arrays::stream).filter(err -> err.getUnsatisfiedConstraint() != null).map(ResolverError::getUnsatisfiedConstraint).toArray(VersionConstraint[]::new);
            int n = unsatisfiedConstraints.length;
            int n2 = 0;
            while (n2 < n) {
                VersionConstraint constraint = versionConstraintArray[n2];
                if (!dependencies.stream().anyMatch(pmb -> DependencyManager.satisfiesConstraint(pmb.getBundleDescription(), constraint))) {
                    List satisfyingBundles = Arrays.stream(state.getBundles()).filter(desc -> DependencyManager.satisfiesConstraint(desc, constraint)).collect(Collectors.toList());
                    for (BundleDescription bundle : satisfyingBundles) {
                        ModelEntry entry = PluginRegistry.findEntry(bundle.getSymbolicName());
                        if (entry == null) continue;
                        dependencies.add(entry.getModel());
                    }
                }
                ++n2;
            }
            return dependencies;
        }
        catch (CoreException e) {
            PDECore.log(e);
            return Collections.emptySet();
        }
    }

    private static boolean satisfiesConstraint(BundleDescription desc, VersionConstraint constraint) {
        if (constraint instanceof GenericSpecification) {
            GenericDescription[] genericDescriptionArray = desc.getGenericCapabilities();
            int n = genericDescriptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericDescription description = genericDescriptionArray[n2];
                if (constraint.isSatisfiedBy((BaseDescription)description)) {
                    return true;
                }
                ++n2;
            }
        } else if (constraint instanceof BundleSpecification) {
            return constraint.getName().equals(desc.getName()) && constraint.getVersionRange().isIncluded(desc.getVersion());
        }
        return false;
    }
}

