/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.rcptt.internal.core.WorkspaceMonitor;
import org.eclipse.rcptt.internal.ui.Messages;

public class RemoveFromFileToDateChange
extends ResourceChange {
    private final IFile file;

    public RemoveFromFileToDateChange(IFile file) {
        this.file = file;
    }

    protected IResource getModifiedResource() {
        return this.file;
    }

    public String getName() {
        return Messages.bind((String)Messages.RemoveFromFileToDateChange_Name, (Object)this.file.getName());
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Long stamp = WorkspaceMonitor.getInstance().removeFromFileToDate(this.file);
        return new UndoRemoveFromFileToDateChange(this.file, stamp);
    }

    private class UndoRemoveFromFileToDateChange
    extends ResourceChange {
        private final IFile file;
        private final Long timestamp;

        public UndoRemoveFromFileToDateChange(IFile file, Long timestamp) {
            this.file = file;
            this.timestamp = timestamp;
        }

        protected IResource getModifiedResource() {
            return this.file;
        }

        public String getName() {
            return Messages.bind((String)Messages.RemoveFromFileToDateChange_UndoName, (Object)this.file.getName());
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            if (this.timestamp != null) {
                WorkspaceMonitor.getInstance().addToFileToDate(this.file, this.timestamp);
            }
            return new RemoveFromFileToDateChange(this.file);
        }
    }
}

