/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.manipulation.Messages;
import org.eclipse.jdt.internal.core.manipulation.search.IOccurrencesFinder;
import org.eclipse.jdt.internal.core.manipulation.search.SearchMessages;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;

public class OccurrencesFinder
extends ASTVisitor
implements IOccurrencesFinder {
    public static final String ID = "OccurrencesFinder";
    public static final String IS_WRITEACCESS = "writeAccess";
    public static final String IS_VARIABLE = "variable";
    private CompilationUnit fRoot;
    private Name fSelectedNode;
    private IBinding fTarget;
    private List<IOccurrencesFinder.OccurrenceLocation> fResult;
    private Set<Name> fWriteUsages;
    private boolean fTargetIsStaticMethodImport;
    private String fReadDescription;
    private String fWriteDescription;

    public OccurrencesFinder() {
        super(true);
    }

    @Override
    public String initialize(CompilationUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, (int)offset, (int)length));
    }

    @Override
    public String initialize(CompilationUnit root, ASTNode node) {
        if (!(node instanceof Name)) {
            return SearchMessages.OccurrencesFinder_no_element;
        }
        this.fRoot = root;
        this.fSelectedNode = (Name)node;
        this.fTarget = this.fSelectedNode.resolveBinding();
        if (this.fTarget == null) {
            return SearchMessages.OccurrencesFinder_no_binding;
        }
        this.fTarget = this.getBindingDeclaration(this.fTarget);
        this.fTargetIsStaticMethodImport = OccurrencesFinder.isStaticImport(this.fSelectedNode.getParent());
        this.fReadDescription = Messages.format(SearchMessages.OccurrencesFinder_occurrence_description, BasicElementLabels.getJavaElementName(this.fTarget.getName()));
        this.fWriteDescription = Messages.format(SearchMessages.OccurrencesFinder_occurrence_write_description, BasicElementLabels.getJavaElementName(this.fTarget.getName()));
        return null;
    }

    private void performSearch() {
        if (this.fResult == null) {
            this.fResult = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
            this.fWriteUsages = new HashSet<Name>();
            this.fRoot.accept((ASTVisitor)this);
        }
    }

    @Override
    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        this.performSearch();
        if (this.fResult.isEmpty()) {
            return null;
        }
        return this.fResult.toArray(new IOccurrencesFinder.OccurrenceLocation[this.fResult.size()]);
    }

    @Override
    public CompilationUnit getASTRoot() {
        return this.fRoot;
    }

    @Override
    public String getJobLabel() {
        return SearchMessages.OccurrencesFinder_searchfor;
    }

    @Override
    public String getElementName() {
        if (this.fSelectedNode != null) {
            return ASTNodes.asString((ASTNode)this.fSelectedNode);
        }
        return null;
    }

    @Override
    public String getUnformattedPluralLabel() {
        return SearchMessages.OccurrencesFinder_label_plural;
    }

    @Override
    public String getUnformattedSingularLabel() {
        return SearchMessages.OccurrencesFinder_label_singular;
    }

    public boolean visit(QualifiedName node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding && ((IVariableBinding)binding).isField()) {
            SimpleName name = node.getName();
            return !this.addUsage((Name)name, name.resolveBinding());
        }
        if (binding instanceof IMethodBinding && OccurrencesFinder.isStaticImport((ASTNode)node)) {
            SimpleName name = node.getName();
            return !this.addPossibleStaticImport((Name)name, (IMethodBinding)binding);
        }
        return !this.addUsage((Name)node, binding);
    }

    private static boolean isStaticImport(ASTNode node) {
        if (!(node instanceof QualifiedName)) {
            return false;
        }
        ASTNode parent = ((QualifiedName)node).getParent();
        return parent instanceof ImportDeclaration && ((ImportDeclaration)parent).isStatic();
    }

    public boolean visit(MethodInvocation node) {
        if (this.fTargetIsStaticMethodImport) {
            return !this.addPossibleStaticImport((Name)node.getName(), node.resolveMethodBinding());
        }
        return true;
    }

    public boolean visit(SimpleName node) {
        this.addUsage((Name)node, node.resolveBinding());
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        Type type = node.getType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getType();
        }
        if (type instanceof SimpleType) {
            Name name = ((SimpleType)type).getName();
            if (name instanceof QualifiedName) {
                name = ((QualifiedName)name).getName();
            }
            this.addUsage(name, (IBinding)node.resolveConstructorBinding());
        } else if (type instanceof NameQualifiedType) {
            SimpleName name = ((NameQualifiedType)type).getName();
            this.addUsage((Name)name, (IBinding)node.resolveConstructorBinding());
        }
        return super.visit(node);
    }

    public boolean visit(Assignment node) {
        SimpleName name = this.getSimpleName(node.getLeftHandSide());
        if (name != null) {
            this.addWrite((Name)name, name.resolveBinding());
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        this.addWrite((Name)node.getName(), (IBinding)node.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (node.getParent() instanceof FieldDeclaration || node.getInitializer() != null) {
            this.addWrite((Name)node.getName(), (IBinding)node.resolveBinding());
        }
        return true;
    }

    public boolean visit(PrefixExpression node) {
        SimpleName name;
        PrefixExpression.Operator operator = node.getOperator();
        if ((operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) && (name = this.getSimpleName(node.getOperand())) != null) {
            this.addWrite((Name)name, name.resolveBinding());
        }
        return true;
    }

    public boolean visit(PostfixExpression node) {
        SimpleName name = this.getSimpleName(node.getOperand());
        if (name != null) {
            this.addWrite((Name)name, name.resolveBinding());
        }
        return true;
    }

    private boolean addWrite(Name node, IBinding binding) {
        if (binding != null && Bindings.equals(this.getBindingDeclaration(binding), this.fTarget)) {
            this.fWriteUsages.add(node);
            return true;
        }
        return false;
    }

    private boolean addUsage(Name node, IBinding binding) {
        if (binding != null && Bindings.equals(this.getBindingDeclaration(binding), this.fTarget)) {
            int flag = 0;
            String description = this.fReadDescription;
            if (this.fTarget instanceof IVariableBinding) {
                boolean isWrite = this.fWriteUsages.remove(node);
                int n = flag = isWrite ? 1 : 2;
                if (isWrite) {
                    description = this.fWriteDescription;
                }
            }
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), node.getLength(), flag, description));
            return true;
        }
        return false;
    }

    @Override
    public int getSearchKind() {
        return 5;
    }

    private boolean addPossibleStaticImport(Name node, IMethodBinding binding) {
        if (binding == null || node == null || !(this.fTarget instanceof IMethodBinding) || !Modifier.isStatic((int)binding.getModifiers())) {
            return false;
        }
        IMethodBinding targetMethodBinding = (IMethodBinding)this.fTarget;
        if ((this.fTargetIsStaticMethodImport || Modifier.isStatic((int)targetMethodBinding.getModifiers())) && targetMethodBinding.getDeclaringClass().getTypeDeclaration() == binding.getDeclaringClass().getTypeDeclaration() && node.getFullyQualifiedName().equals(targetMethodBinding.getName())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStartPosition(), node.getLength(), 0, this.fReadDescription));
            return true;
        }
        return false;
    }

    private SimpleName getSimpleName(Expression expression) {
        if (expression instanceof SimpleName) {
            return (SimpleName)expression;
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).getName();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName();
        }
        return null;
    }

    private IBinding getBindingDeclaration(IBinding binding) {
        switch (binding.getKind()) {
            case 2: {
                return ((ITypeBinding)binding).getTypeDeclaration();
            }
            case 4: {
                return ((IMethodBinding)binding).getMethodDeclaration();
            }
            case 3: {
                return ((IVariableBinding)binding).getVariableDeclaration();
            }
        }
        return binding;
    }

    @Override
    public String getID() {
        return ID;
    }
}

