/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.log.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.rcptt.core.builder.IQ7ProblemReporter;
import org.eclipse.rcptt.core.builder.IQ7Validator;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.verifications.log.ErrorLogVerification;
import org.eclipse.rcptt.verifications.log.LogEntryPredicate;
import org.eclipse.rcptt.verifications.log.tools.ErrorLogUtil;

public class ErrorLogVerificationValidator
implements IQ7Validator {
    public void validate(IQ7NamedElement element, IQ7ProblemReporter reporter, IProgressMonitor monitor) {
        if (!(element instanceof IVerification)) {
            return;
        }
        try {
            NamedElement namedElement = element.getNamedElement();
            if (namedElement instanceof ErrorLogVerification) {
                Processor processor = new Processor(element, reporter);
                processor.process((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            }
        }
        catch (ModelException e) {
            throw new RuntimeException(e);
        }
    }

    public void reconcile(IQ7NamedElement content, String eclCode, IQ7ProblemReporter reporter, IProgressMonitor nullProgressMonitor) {
    }

    class Processor {
        private final IQ7NamedElement element;
        private final IQ7ProblemReporter reporter;
        private final ErrorLogVerification verification;

        public Processor(IQ7NamedElement element, IQ7ProblemReporter reporter) throws ModelException {
            this.element = element;
            this.reporter = reporter;
            this.verification = (ErrorLogVerification)element.getNamedElement();
        }

        private LogEntryPredicate findDenying(LogEntryPredicate predicate) {
            for (LogEntryPredicate denied : this.verification.getDenied()) {
                if (!ErrorLogUtil.includes((LogEntryPredicate)predicate, (LogEntryPredicate)denied)) continue;
                return denied;
            }
            return null;
        }

        public void processAllowed(LogEntryPredicate predicate) {
            LogEntryPredicate denied = this.findDenying(predicate);
            if (denied != null) {
                this.reporter.reportProblem((IFile)this.element.getResource(), IQ7ProblemReporter.ProblemType.Warning, "Predicate " + ErrorLogUtil.describe((LogEntryPredicate)predicate) + " is always allowed by another predicate " + ErrorLogUtil.describe((LogEntryPredicate)predicate), ErrorLogUtil.getIndex((LogEntryPredicate)denied), -1, -1, -1);
                this.reporter.reportProblem((IFile)this.element.getResource(), IQ7ProblemReporter.ProblemType.Warning, "Predicate " + ErrorLogUtil.describe((LogEntryPredicate)predicate) + " always allows another predicate " + ErrorLogUtil.describe((LogEntryPredicate)denied), ErrorLogUtil.getIndex((LogEntryPredicate)predicate), -1, -1, -1);
            }
        }

        public void process(IProgressMonitor monitor) {
            monitor.beginTask("", this.verification.getRequired().size() + this.verification.getAllowed().size());
            for (LogEntryPredicate predicate : this.verification.getRequired()) {
                this.processAllowed(predicate);
            }
            for (LogEntryPredicate predicate : this.verification.getAllowed()) {
                this.processAllowed(predicate);
            }
        }
    }
}

