/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.egit.core.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.egit.ui.internal.SecureStoreUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.components.RepositorySelection;
import org.eclipse.egit.ui.internal.push.AddRemotePage;
import org.eclipse.egit.ui.internal.push.ConfirmationPage;
import org.eclipse.egit.ui.internal.push.PushBranchPage;
import org.eclipse.egit.ui.internal.push.PushOperationUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class PushBranchWizard
extends Wizard {
    private final Repository repository;
    private final ObjectId commitToPush;
    private final Ref ref;
    private AddRemotePage addRemotePage;
    private PushBranchPage pushBranchPage;
    private ConfirmationPage confirmationPage;
    private boolean confirmationRequired;

    public PushBranchWizard(Repository repository, Ref ref) {
        this(repository, ref.getObjectId(), ref);
    }

    public PushBranchWizard(Repository repository, ObjectId commitToPush) {
        this(repository, commitToPush, null);
    }

    private PushBranchWizard(Repository repository, ObjectId commitToPush, Ref ref) {
        this.repository = repository;
        this.commitToPush = commitToPush;
        this.ref = ref;
        assert (this.repository != null);
        assert (this.commitToPush != null);
        Set remoteNames = repository.getConfig().getSubsections("remote");
        if (remoteNames.isEmpty()) {
            this.addRemotePage = new AddRemotePage(repository);
        }
        this.pushBranchPage = new PushBranchPage(repository, commitToPush, ref){

            public void setVisible(boolean visible) {
                if (visible && PushBranchWizard.this.addRemotePage != null) {
                    this.setSelectedRemote(PushBranchWizard.this.addRemotePage.getRemoteName(), PushBranchWizard.this.addRemotePage.getSelection().getURI());
                }
                super.setVisible(visible);
            }
        };
        this.pushBranchPage.setShowNewRemoteButton(this.addRemotePage == null);
        this.confirmationPage = new ConfirmationPage(repository){

            public void setVisible(boolean visible) {
                PushBranchWizard.this.confirmationRequired = true;
                this.setSelection(PushBranchWizard.this.getRepositorySelection(), PushBranchWizard.this.getRefSpecs());
                AddRemotePage remotePage = PushBranchWizard.this.getAddRemotePage();
                if (remotePage != null) {
                    this.setCredentials(remotePage.getCredentials());
                }
                super.setVisible(visible);
            }
        };
        this.confirmationRequired = this.addRemotePage != null;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_PUSH);
    }

    public void addPages() {
        if (this.addRemotePage != null) {
            this.addPage((IWizardPage)this.addRemotePage);
        }
        this.addPage((IWizardPage)this.pushBranchPage);
        this.addPage((IWizardPage)this.confirmationPage);
    }

    public String getWindowTitle() {
        if (this.ref != null) {
            return MessageFormat.format(UIText.PushBranchWizard_WindowTitle, Repository.shortenRefName((String)this.ref.getName()));
        }
        return UIText.PushCommitHandler_pushCommitTitle;
    }

    public boolean canFinish() {
        if (!this.confirmationRequired) {
            return this.pushBranchPage.isPageComplete();
        }
        return this.getContainer().getCurrentPage() == this.confirmationPage && this.confirmationPage.isPageComplete();
    }

    public boolean performFinish() {
        try {
            AddRemotePage remotePage = this.getAddRemotePage();
            if (remotePage != null) {
                this.storeCredentials(remotePage);
                URIish uri = remotePage.getSelection().getURI();
                this.configureNewRemote(uri);
            }
            if (this.pushBranchPage.getUpstreamConfig() != null) {
                this.configureUpstream();
            }
            this.startPush();
        }
        catch (IOException e) {
            this.showError(e.getMessage());
            return false;
        }
        catch (URISyntaxException e) {
            this.showError(e.getMessage());
            return false;
        }
        return true;
    }

    private void showError(String message) {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page instanceof WizardPage) {
            ((WizardPage)page).setErrorMessage(message);
            ((WizardPage)page).setPageComplete(false);
        }
    }

    private AddRemotePage getAddRemotePage() {
        if (this.addRemotePage != null) {
            return this.addRemotePage;
        }
        return this.pushBranchPage.getAddRemotePage();
    }

    private RepositorySelection getRepositorySelection() {
        AddRemotePage remotePage = this.getAddRemotePage();
        if (remotePage != null) {
            return remotePage.getSelection();
        }
        return new RepositorySelection(null, this.pushBranchPage.getRemoteConfig());
    }

    private List<RefSpec> getRefSpecs() {
        String src = this.ref != null ? this.ref.getName() : this.commitToPush.getName();
        String dst = this.pushBranchPage.getFullRemoteReference();
        RefSpec refSpec = new RefSpec().setSourceDestination(src, dst).setForceUpdate(this.pushBranchPage.isForceUpdateSelected());
        return Arrays.asList(refSpec);
    }

    private void storeCredentials(AddRemotePage remotePage) {
        URIish uri;
        if (remotePage.getStoreInSecureStore() && (uri = remotePage.getSelection().getURI()) != null) {
            SecureStoreUtils.storeCredentials(remotePage.getCredentials(), uri);
        }
    }

    private void configureNewRemote(URIish uri) throws URISyntaxException, IOException {
        StoredConfig config = this.repository.getConfig();
        String remoteName = this.getRemoteName();
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, remoteName);
        remoteConfig.addURI(uri);
        RefSpec defaultFetchSpec = new RefSpec().setForceUpdate(true).setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
        remoteConfig.addFetchRefSpec(defaultFetchSpec);
        remoteConfig.update((Config)config);
        config.save();
    }

    private void configureUpstream() throws IOException {
        if (this.ref == null) {
            return;
        }
        String remoteName = this.getRemoteName();
        String fullRemoteBranchName = this.pushBranchPage.getFullRemoteReference();
        String localBranchName = Repository.shortenRefName((String)this.ref.getName());
        StoredConfig config = this.repository.getConfig();
        config.setString("branch", localBranchName, "remote", remoteName);
        config.setString("branch", localBranchName, "merge", fullRemoteBranchName);
        BranchConfig.BranchRebaseMode rebaseMode = this.pushBranchPage.getUpstreamConfig();
        if (rebaseMode != null) {
            config.setEnum("branch", localBranchName, "rebase", (Enum)rebaseMode);
        }
        config.save();
    }

    private void startPush() throws IOException {
        PushOperationResult result = this.confirmationPage.getConfirmedResult();
        PushOperationSpecification pushSpec = result != null ? result.deriveSpecification(this.confirmationPage.isRequireUnchangedSelected()) : PushOperationSpecification.create((Repository)this.repository, (RemoteConfig)this.pushBranchPage.getRemoteConfig(), this.getRefSpecs());
        PushOperationUI pushOperationUI = new PushOperationUI(this.repository, pushSpec, false);
        pushOperationUI.setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        pushOperationUI.setShowConfigureButton(false);
        if (result != null && this.confirmationPage.isShowOnlyIfChangedSelected()) {
            pushOperationUI.setExpectedResult(result);
        }
        pushOperationUI.start();
    }

    private String getRemoteName() {
        return this.pushBranchPage.getRemoteConfig().getName();
    }
}

