/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import org.eclipse.ant.internal.ui.AntSourceViewerConfiguration;
import org.eclipse.ant.internal.ui.editor.formatter.FormattingPreferences;
import org.eclipse.ant.internal.ui.editor.formatter.XmlFormatter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

class AntPreviewerUpdater {
    private Color fForegroundColor = null;
    private Color fBackgroundColor = null;
    private Color fSelectionBackgroundColor = null;
    private Color fSelectionForegroundColor = null;

    public AntPreviewerUpdater(final SourceViewer viewer, final AntSourceViewerConfiguration configuration, final IPreferenceStore preferenceStore) {
        this.initializeViewerColors((ISourceViewer)viewer, preferenceStore);
        IPropertyChangeListener fontChangeListener = event -> {
            if (event.getProperty().equals("org.eclipse.jface.textfont")) {
                Font font = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
                viewer.getTextWidget().setFont(font);
            }
        };
        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("AbstractTextEditor.Color.Foreground".equals(property) || "AbstractTextEditor.Color.Foreground.SystemDefault".equals(property) || "AbstractTextEditor.Color.Background".equals(property) || "AbstractTextEditor.Color.Background.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionForeground".equals(property) || "AbstractTextEditor.Color.SelectionForeground.SystemDefault".equals(property) || "AbstractTextEditor.Color.SelectionBackground".equals(property) || "AbstractTextEditor.Color.SelectionBackground.SystemDefault".equals(property)) {
                    AntPreviewerUpdater.this.initializeViewerColors((ISourceViewer)viewer, preferenceStore);
                }
                if (configuration.affectsTextPresentation(event)) {
                    configuration.adaptToPreferenceChange(event);
                    viewer.invalidateTextPresentation();
                }
                if (FormattingPreferences.affectsFormatting(event)) {
                    this.format(viewer, preferenceStore);
                }
            }

            private void format(SourceViewer sourceViewer, IPreferenceStore store) {
                String contents = sourceViewer.getDocument().get();
                FormattingPreferences prefs = new FormattingPreferences();
                prefs.setPreferenceStore(store);
                contents = XmlFormatter.format(contents, prefs);
                viewer.getDocument().set(contents);
            }
        };
        viewer.getTextWidget().addDisposeListener(e -> {
            preferenceStore.removePropertyChangeListener(propertyChangeListener);
            JFaceResources.getFontRegistry().removeListener(fontChangeListener);
        });
        JFaceResources.getFontRegistry().addListener(fontChangeListener);
        preferenceStore.addPropertyChangeListener(propertyChangeListener);
    }

    protected void initializeViewerColors(ISourceViewer viewer, IPreferenceStore store) {
        StyledText styledText = viewer.getTextWidget();
        Color color = store.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Foreground", styledText.getDisplay());
        styledText.setForeground(color);
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
        }
        this.fForegroundColor = color;
        color = store.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.Background", styledText.getDisplay());
        styledText.setBackground(color);
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
        }
        this.fBackgroundColor = color;
        color = store.getBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.SelectionForeground", styledText.getDisplay());
        styledText.setSelectionForeground(color);
        if (this.fSelectionForegroundColor != null) {
            this.fSelectionForegroundColor.dispose();
        }
        this.fSelectionForegroundColor = color;
        color = store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") ? null : this.createColor(store, "AbstractTextEditor.Color.SelectionBackground", styledText.getDisplay());
        styledText.setSelectionBackground(color);
        if (this.fSelectionBackgroundColor != null) {
            this.fSelectionBackgroundColor.dispose();
        }
        this.fSelectionBackgroundColor = color;
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void dispose() {
        if (this.fForegroundColor != null) {
            this.fForegroundColor.dispose();
            this.fForegroundColor = null;
        }
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        if (this.fSelectionForegroundColor != null) {
            this.fSelectionForegroundColor.dispose();
            this.fSelectionForegroundColor = null;
        }
        if (this.fSelectionBackgroundColor != null) {
            this.fSelectionBackgroundColor.dispose();
            this.fSelectionBackgroundColor = null;
        }
    }
}

