/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.IPersistenceModelFactory;
import org.eclipse.rcptt.core.persistence.plain.PlainReader;
import org.eclipse.rcptt.core.persistence.plain.PlainTextPersistenceModel;

public class PlainTextPersistenceModelFactory
implements IPersistenceModelFactory {
    @Override
    public IPersistenceModel createModel(Resource resource) {
        return new PlainTextPersistenceModel(resource);
    }

    @Override
    public boolean isSupported(InputStream stream) {
        try (PlainReader reader = null;){
            String version;
            reader = new PlainReader(stream);
            Map<String, String> header = reader.readHeader();
            if (header != null && (version = header.get("Format-Version")) != null && version.equals("1.0")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSupported(File file) {
        return false;
    }
}

