/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.text.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.VerificationProcessor;
import org.eclipse.rcptt.core.scenario.Verification;
import org.eclipse.rcptt.ecl.runtime.IProcess;
import org.eclipse.rcptt.tesla.ecl.impl.rap.TeslaBridge;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.verifications.runtime.ErrorList;
import org.eclipse.rcptt.verifications.text.TextFactory;
import org.eclipse.rcptt.verifications.text.TextVerification;
import org.eclipse.swt.widgets.Widget;

public class TextVerificationProcessor
extends VerificationProcessor {
    public void finish(Verification verification, Object data, IProcess process) throws CoreException {
        final TextVerification textVerification = (TextVerification)verification;
        final SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)textVerification.getSelector(), (IProcess)process);
        Widget widget = swtuiElement.widget;
        final ErrorList errors = new ErrorList();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String actualText;
                String expectedText = textVerification.getText();
                if (expectedText == null) {
                    expectedText = "";
                }
                if ((actualText = PlayerTextUtils.getTextForVerification((SWTUIElement)swtuiElement)) == null) {
                    actualText = "";
                }
                if (!actualText.equals(expectedText)) {
                    errors.add("Expected text is \"%s\", but it was \"%s\".", new Object[]{expectedText, actualText});
                }
            }
        });
        errors.throwIfAny(String.format("Widget text verification '%s' failed:", verification.getName()), ((Object)((Object)this)).getClass().getPackage().getName(), verification.getId());
    }

    public Verification create(EObject param, IProcess process) throws CoreException {
        final TextVerification p = (TextVerification)param;
        final SWTUIElement swtuiElement = TeslaBridge.resolveSWTUIElement((String)p.getSelector(), (IProcess)process);
        Widget widget = swtuiElement.widget;
        final TextVerification result = TextFactory.eINSTANCE.createTextVerification();
        widget.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result.setSelector(p.getSelector());
                result.setText(PlayerTextUtils.getTextForVerification((SWTUIElement)swtuiElement));
                result.setIgnoreStyling(true);
            }
        });
        return result;
    }
}

