/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.preferences.DoublePreferencesPreferencePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GitPreferenceRoot
extends DoublePreferencesPreferencePage
implements IWorkbenchPreferencePage {
    private static final int GROUP_SPAN = 3;
    private static final String[][] HTTP_CLIENT_NAMES_AND_VALUES = new String[2][2];
    private static final boolean HAS_DEBUG_UI = GitPreferenceRoot.hasDebugUiBundle();
    private Group remoteConnectionsGroup;
    private BooleanFieldEditor useSshAgent;
    private ComboFieldEditor defaultSshAgent;

    static {
        GitPreferenceRoot.HTTP_CLIENT_NAMES_AND_VALUES[0][0] = UIText.GitPreferenceRoot_HttpClient_Jdk_Label;
        GitPreferenceRoot.HTTP_CLIENT_NAMES_AND_VALUES[0][1] = "jdk";
        GitPreferenceRoot.HTTP_CLIENT_NAMES_AND_VALUES[1][0] = UIText.GitPreferenceRoot_HttpClient_Apache_Label;
        GitPreferenceRoot.HTTP_CLIENT_NAMES_AND_VALUES[1][1] = "apache";
    }

    public GitPreferenceRoot() {
        super(0);
    }

    public static boolean autoAddToIndex() {
        return Activator.getDefault().getPreferenceStore().getBoolean("merge_tool_auto_add");
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    @Override
    protected IPreferenceStore doGetSecondaryPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.egit.core");
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite main = this.getFieldEditorParent();
        GridLayoutFactory.swtDefaults().margins(0, 0).applyTo(main);
        Group cloningGroup = new Group(main, 16);
        cloningGroup.setText(UIText.GitPreferenceRoot_CloningRepoGroupHeader);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)cloningGroup);
        DirectoryFieldEditor editor = new DirectoryFieldEditor("core_defaultRepositoryDir", UIText.GitPreferenceRoot_DefaultRepoFolderLabel, (Composite)cloningGroup){
            private static final int NUMBER_OF_OWN_CONTROLS = 1;

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
            }

            protected boolean doCheckState() {
                String substitutedFileName;
                String fileName = this.getTextControl().getText();
                if ((fileName = fileName.trim()).length() == 0 && this.isEmptyStringAllowed()) {
                    return true;
                }
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                try {
                    substitutedFileName = manager.performStringSubstitution(fileName);
                }
                catch (CoreException e) {
                    return false;
                }
                File file = new File(substitutedFileName);
                return !file.exists() || file.isDirectory();
            }

            public int getNumberOfControls() {
                return super.getNumberOfControls() + 1;
            }

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                super.doFillIntoGrid(parent, numColumns - 1);
            }

            protected void adjustForNumColumns(int numColumns) {
                super.adjustForNumColumns(numColumns - 1);
            }

            protected void createControl(Composite parent) {
                super.setValidateStrategy(0);
                super.createControl(parent);
                if (HAS_DEBUG_UI) {
                    this.addVariablesButton(parent);
                }
            }

            private void addVariablesButton(Composite parent) {
                Button variableButton = new Button(parent, 8);
                variableButton.setText(UIText.GitPreferenceRoot_DefaultRepoFolderVariableButton);
                variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
                        int returnCode = dialog.open();
                        if (returnCode == 0) {
                            this.setStringValue(dialog.getVariableExpression());
                        }
                    }
                });
            }
        };
        this.updateMargins(cloningGroup);
        editor.setEmptyStringAllowed(false);
        editor.getLabelControl((Composite)cloningGroup).setToolTipText(UIText.GitPreferenceRoot_DefaultRepoFolderTooltip);
        this.addField((FieldEditor)editor);
        this.remoteConnectionsGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.remoteConnectionsGroup);
        this.remoteConnectionsGroup.setText(UIText.GitPreferenceRoot_RemoteConnectionsGroupHeader);
        IntegerFieldEditor pullEditor = new IntegerFieldEditor("core_max_pull_threads_count", UIText.GitPreferenceRoot_MaxPullThreadsCount, (Composite)this.remoteConnectionsGroup){

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
            }
        };
        pullEditor.getLabelControl((Composite)this.remoteConnectionsGroup).setToolTipText(UIText.GitPreferenceRoot_MaxPullThreadsCountTooltip);
        this.addField((FieldEditor)pullEditor);
        IntegerFieldEditor timeoutEditor = new IntegerFieldEditor("core_remote_connection_timeout", UIText.RemoteConnectionPreferencePage_TimeoutLabel, (Composite)this.remoteConnectionsGroup){

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
            }
        };
        timeoutEditor.getLabelControl((Composite)this.remoteConnectionsGroup).setToolTipText(UIText.RemoteConnectionPreferencePage_ZeroValueTooltip);
        this.addField((FieldEditor)timeoutEditor);
        ComboFieldEditor httpClient = new ComboFieldEditor("core_http_client", UIText.RemoteConnectionPreferencePage_HttpClientLabel, HTTP_CLIENT_NAMES_AND_VALUES, (Composite)this.remoteConnectionsGroup){

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
            }
        };
        this.addField((FieldEditor)httpClient);
        ConnectorFactory factory = ConnectorFactory.getDefault();
        if (factory != null) {
            boolean isWindows = SystemReader.getInstance().isWindows();
            this.useSshAgent = new BooleanFieldEditor("core_ssh_agent", UIText.GitPreferenceRoot_SshAgent_Label, (Composite)this.remoteConnectionsGroup){

                public int getNumberOfControls() {
                    return 2;
                }

                public void setPreferenceStore(IPreferenceStore store) {
                    super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
                }
            };
            if (!isWindows) {
                String productName = this.getProductName();
                this.useSshAgent.getDescriptionControl((Composite)this.remoteConnectionsGroup).setToolTipText(MessageFormat.format(UIText.GitPreferenceRoot_SshAgent_Tooltip, productName));
            }
            this.addField((FieldEditor)this.useSshAgent);
            Collection available = factory.getSupportedConnectors();
            if (available.size() > 1) {
                String[][] items = new String[available.size()][2];
                int i = 0;
                for (ConnectorFactory.ConnectorDescriptor desc : available) {
                    items[i][0] = desc.getDisplayName();
                    items[i][1] = desc.getIdentityAgent();
                    ++i;
                }
                this.defaultSshAgent = new ComboFieldEditor("core_ssh_default_agent", UIText.GitPreferenceRoot_SshDefaultAgent_Label, items, (Composite)this.remoteConnectionsGroup){

                    public void setPreferenceStore(IPreferenceStore store) {
                        super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
                    }
                };
                this.defaultSshAgent.getLabelControl((Composite)this.remoteConnectionsGroup).setToolTipText(UIText.GitPreferenceRoot_SshDefaultAgent_Tooltip);
                GridDataFactory.fillDefaults().indent(UIUtils.getControlIndent(), 0).applyTo((Control)this.defaultSshAgent.getLabelControl((Composite)this.remoteConnectionsGroup));
                this.addField((FieldEditor)this.defaultSshAgent);
            }
        }
        this.updateMargins(this.remoteConnectionsGroup);
        Group repoChangeScannerGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)repoChangeScannerGroup);
        repoChangeScannerGroup.setText(UIText.GitPreferenceRoot_RepoChangeScannerGroupHeader);
        IntegerFieldEditor intervalField = new IntegerFieldEditor("refesh_index_interval", UIText.RefreshPreferencesPage_RefreshIndexInterval, (Composite)repoChangeScannerGroup);
        intervalField.getLabelControl((Composite)repoChangeScannerGroup).setToolTipText(UIText.RefreshPreferencesPage_RefreshIndexIntervalTooltip);
        this.addField((FieldEditor)intervalField);
        this.addField((FieldEditor)new BooleanFieldEditor("refesh_only_when_active", UIText.RefreshPreferencesPage_RefreshOnlyWhenActive, (Composite)repoChangeScannerGroup){

            public int getNumberOfControls() {
                return 2;
            }
        });
        this.updateMargins(repoChangeScannerGroup);
        Group blameGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)blameGroup);
        blameGroup.setText(UIText.GitPreferenceRoot_BlameGroupHeader);
        this.addField((FieldEditor)new BooleanFieldEditor("Blame_IgnoreWhitespace", UIText.GitPreferenceRoot_BlameIgnoreWhitespaceLabel, (Composite)blameGroup));
        this.updateMargins(blameGroup);
        Group secureGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)secureGroup);
        secureGroup.setText(UIText.GitPreferenceRoot_SecureStoreGroupLabel);
        this.addField((FieldEditor)new BooleanFieldEditor("CloneWizard_StoreInSecureStore", UIText.GitPreferenceRoot_SecureStoreUseByDefault, (Composite)secureGroup));
        this.addField((FieldEditor)new BooleanFieldEditor("core_save_credentials_in_secure_store", UIText.GitPreferenceRoot_SecureStoreUseForSshKeys, (Composite)secureGroup){

            public void setPreferenceStore(IPreferenceStore store) {
                super.setPreferenceStore(store == null ? null : GitPreferenceRoot.this.getSecondaryPreferenceStore());
            }
        });
        this.updateMargins(secureGroup);
        boolean lfsAvailable = LfsFactory.getInstance().isAvailable() && LfsFactory.getInstance().getInstallCommand() != null;
        Group lfsGroup = new Group(main, 16);
        GridLayoutFactory.fillDefaults().applyTo((Composite)lfsGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)lfsGroup);
        lfsGroup.setText(lfsAvailable ? UIText.GitPreferenceRoot_lfsSupportCaption : UIText.GitPreferenceRoot_lfsSupportCaptionNotAvailable);
        Button lfsEnable = new Button((Composite)lfsGroup, 8);
        lfsEnable.setEnabled(lfsAvailable);
        lfsEnable.setText(UIText.GitPreferenceRoot_lfsSupportInstall);
        lfsEnable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LfsFactory.LfsInstallCommand cmd = LfsFactory.getInstance().getInstallCommand();
                try {
                    if (cmd != null) {
                        cmd.call();
                        MessageDialog.openInformation((Shell)GitPreferenceRoot.this.getShell(), (String)UIText.GitPreferenceRoot_lfsSupportSuccessTitle, (String)UIText.GitPreferenceRoot_lfsSupportSuccessMessage);
                    }
                }
                catch (Exception ex) {
                    Activator.handleError(UIText.ConfigurationChecker_installLfsCannotInstall, ex, true);
                }
            }
        });
        this.updateMargins(lfsGroup);
    }

    protected void initialize() {
        super.initialize();
        if (this.defaultSshAgent != null) {
            this.useSshAgent.setPropertyChangeListener(event -> {
                if ("field_editor_value".equals(event.getProperty())) {
                    this.defaultSshAgent.setEnabled(((Boolean)event.getNewValue()).booleanValue(), (Composite)this.remoteConnectionsGroup);
                }
            });
        }
    }

    private String getProductName() {
        IProduct product = Platform.getProduct();
        String name = product == null ? null : product.getName();
        return name == null ? UIText.GitPreferenceRoot_DefaultProductName : name;
    }

    private void updateMargins(Group group) {
        GridLayout layout = (GridLayout)group.getLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
    }

    private static final boolean hasDebugUiBundle() {
        try {
            return Class.forName("org.eclipse.debug.ui.StringVariableSelectionDialog") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

