/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.bundle.BundleObject;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.osgi.framework.BundleException;

public class PDEManifestElement
extends BundleObject {
    private static final long serialVersionUID = 1L;
    protected String[] fValueComponents;
    protected TreeMap<String, Serializable> fAttributes;
    protected TreeMap<String, Serializable> fDirectives;
    protected transient ManifestHeader fHeader;

    public PDEManifestElement(ManifestHeader header, String value) {
        this.setHeader(header);
        this.setValue(value);
        this.setModel(this.fHeader.getBundle().getModel());
    }

    protected PDEManifestElement(ManifestHeader header, ManifestElement manifestElement) {
        this.setHeader(header);
        this.init(manifestElement);
        this.setModel(this.fHeader.getBundle().getModel());
    }

    public String[] getValueComponents() {
        return this.fValueComponents;
    }

    protected void setValueComponents(String[] valueComponents) {
        this.fValueComponents = valueComponents;
    }

    public String[] getAttributes(String key) {
        return this.getTableValues(this.fAttributes, key);
    }

    public String getAttribute(String key) {
        return this.getTableValue(this.fAttributes, key);
    }

    public Set<String> getKeys() {
        return this.getTableKeys(this.fAttributes);
    }

    public void addAttribute(String key, String value) {
        this.fAttributes = this.addTableValue(this.fAttributes, key, value);
    }

    public void setAttribute(String key, String value) {
        this.fAttributes = this.setTableValue(this.fAttributes, key, value);
    }

    public String getDirective(String key) {
        return this.getTableValue(this.fDirectives, key);
    }

    public String[] getDirectives(String key) {
        return this.getTableValues(this.fDirectives, key);
    }

    public Set<String> getDirectiveKeys() {
        return this.getTableKeys(this.fDirectives);
    }

    public void addDirective(String key, String value) {
        this.fDirectives = this.addTableValue(this.fDirectives, key, value);
    }

    public void setDirective(String key, String value) {
        this.fDirectives = this.setTableValue(this.fDirectives, key, value);
    }

    private String getTableValue(TreeMap<String, Serializable> table, String key) {
        if (table == null) {
            return null;
        }
        Serializable result = table.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)((Object)result);
        }
        List valueList = (List)((Object)result);
        return (String)valueList.get(valueList.size() - 1);
    }

    private String[] getTableValues(TreeMap<String, Serializable> table, String key) {
        if (table == null) {
            return null;
        }
        Serializable result = table.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return new String[]{(String)((Object)result)};
        }
        List valueList = (List)((Object)result);
        return valueList.toArray(new String[valueList.size()]);
    }

    private Set<String> getTableKeys(TreeMap<String, Serializable> table) {
        if (table == null) {
            return null;
        }
        return table.keySet();
    }

    private TreeMap<String, Serializable> addTableValue(TreeMap<String, Serializable> table, String key, String value) {
        Serializable curValue;
        if (table == null) {
            table = new TreeMap();
        }
        if ((curValue = table.get(key)) != null) {
            ArrayList<String> newList;
            if (curValue instanceof ArrayList) {
                newList = (ArrayList<String>)curValue;
            } else {
                newList = new ArrayList<String>(5);
                newList.add((String)((Object)curValue));
            }
            newList.add(value);
            table.put(key, newList);
        } else {
            table.put(key, (Serializable)((Object)value));
        }
        return table;
    }

    private TreeMap<String, Serializable> setTableValue(TreeMap<String, Serializable> table, String key, String value) {
        if (table == null) {
            table = new TreeMap();
        }
        if (value == null || value.trim().length() == 0) {
            table.remove(key);
        } else {
            table.put(key, (Serializable)((Object)value));
        }
        return table;
    }

    public void setValue(String value) {
        if (value == null) {
            this.setValueComponents(new String[0]);
            return;
        }
        try {
            ManifestElement[] elements = ManifestElement.parseHeader((String)this.fHeader.fName, (String)value);
            if (elements != null && elements.length > 0) {
                this.init(elements[0]);
            }
        }
        catch (BundleException bundleException) {}
    }

    private void init(ManifestElement manifestElement) {
        Enumeration dirKeys;
        int n;
        this.setValueComponents(manifestElement.getValueComponents());
        Enumeration attKeys = manifestElement.getKeys();
        if (attKeys != null) {
            while (attKeys.hasMoreElements()) {
                String attKey = (String)attKeys.nextElement();
                String[] values = ManifestElement.getArrayFromList((String)manifestElement.getAttribute(attKey));
                if (values == null) continue;
                String[] stringArray = values;
                n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    this.addAttribute(attKey, value);
                    ++n2;
                }
            }
        }
        if ((dirKeys = manifestElement.getDirectiveKeys()) != null) {
            while (dirKeys.hasMoreElements()) {
                String[] values;
                String dirKey = (String)dirKeys.nextElement();
                String[] stringArray = values = ManifestElement.getArrayFromList((String)manifestElement.getDirective(dirKey));
                int n3 = values.length;
                n = 0;
                while (n < n3) {
                    String value = stringArray[n];
                    this.addDirective(dirKey, value);
                    ++n;
                }
            }
        }
    }

    public String write() {
        StringBuilder sb = new StringBuilder(this.getValue());
        this.appendValuesToBuffer(sb, this.fAttributes);
        this.appendValuesToBuffer(sb, this.fDirectives);
        return sb.toString();
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        if (this.fValueComponents == null) {
            return "";
        }
        int i = 0;
        while (i < this.fValueComponents.length) {
            if (i != 0) {
                sb.append("; ");
            }
            sb.append(this.fValueComponents[i]);
            ++i;
        }
        return sb.toString();
    }

    protected void appendValuesToBuffer(StringBuilder sb, TreeMap<String, Serializable> table) {
        if (table == null) {
            return;
        }
        for (Map.Entry<String, Serializable> entry : table.entrySet()) {
            boolean wrap;
            String dkey = entry.getKey();
            Serializable value = entry.getValue();
            if (value == null) continue;
            sb.append(";");
            sb.append(dkey);
            sb.append(table.equals(this.fDirectives) ? ":=" : "=");
            if (value instanceof String) {
                boolean wrap2 = this.shouldWrap(value.toString());
                if (wrap2) {
                    sb.append("\"");
                }
                sb.append(value);
                if (!wrap2) continue;
                sb.append("\"");
                continue;
            }
            if (!(value instanceof ArrayList)) continue;
            ArrayList values = (ArrayList)value;
            boolean bl = wrap = values.size() > 1 || values.size() == 1 && this.shouldWrap(values.get(0).toString());
            if (wrap) {
                sb.append("\"");
            }
            int i = 0;
            while (i < values.size()) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(values.get(i));
                ++i;
            }
            if (!wrap) continue;
            sb.append("\"");
        }
    }

    private boolean shouldWrap(String value) {
        return value.indexOf(32) != -1 || value.indexOf(44) != -1 || value.indexOf(46) != -1 || value.indexOf(91) != -1 || value.indexOf(40) != -1;
    }

    public ManifestHeader getHeader() {
        return this.fHeader;
    }

    public void setHeader(ManifestHeader header) {
        this.fHeader = header;
    }

    public void reconnect(IBundleModel model, ManifestHeader header) {
        super.reconnect(model);
        this.fHeader = header;
    }
}

