/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.sherlock.core.internal;

import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.rcptt.sherlock.core.IPluginFilter;
import org.eclipse.rcptt.sherlock.core.IStatusFilter;
import org.eclipse.rcptt.sherlock.core.PluginFilters;
import org.eclipse.rcptt.sherlock.core.StatusFilters;

public class SherlockLogListener
implements ILogListener {
    private final ListenerList listeners = new ListenerList();

    public void addLogListener(ILogListener listener, IStatusFilter statusFilter, IPluginFilter pluginFilter) {
        if (statusFilter == null) {
            statusFilter = StatusFilters.all();
        }
        if (pluginFilter == null) {
            pluginFilter = PluginFilters.all();
        }
        this.listeners.add((Object)new ListenerEntry(listener, statusFilter, pluginFilter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogListener(ILogListener listener) {
        ListenerList listenerList = this.listeners;
        synchronized (listenerList) {
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (((ListenerEntry)obj).listener == listener) {
                    this.listeners.remove(obj);
                    break;
                }
                ++n2;
            }
        }
    }

    public void logging(IStatus status, String plugin) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ListenerEntry entry = (ListenerEntry)obj;
            if (entry.statusFilter.matches(status) && entry.pluginFilter.matches(plugin)) {
                entry.listener.logging(status, plugin);
            }
            ++n2;
        }
    }

    private static class ListenerEntry {
        public final ILogListener listener;
        public final IStatusFilter statusFilter;
        public final IPluginFilter pluginFilter;

        public ListenerEntry(ILogListener listener, IStatusFilter statusFilter, IPluginFilter pluginFilter) {
            this.listener = listener;
            this.statusFilter = statusFilter;
            this.pluginFilter = pluginFilter;
        }
    }
}

