/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVParser;

public class CSVParserBuilder {
    char separator = (char)44;
    char quoteChar = (char)34;
    char escapeChar = (char)92;
    boolean strictQuotes = false;
    boolean ignoreLeadingWhiteSpace = true;
    boolean ignoreQuotations = false;

    CSVParserBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    CSVParserBuilder withQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    CSVParserBuilder withEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    CSVParserBuilder withStrictQuotes(boolean strictQuotes) {
        this.strictQuotes = strictQuotes;
        return this;
    }

    CSVParserBuilder withIgnoreLeadingWhiteSpace(boolean ignoreLeadingWhiteSpace) {
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        return this;
    }

    CSVParserBuilder withIgnoreQuotations(boolean ignoreQuotations) {
        this.ignoreQuotations = ignoreQuotations;
        return this;
    }

    CSVParser build() {
        return new CSVParser(this.separator, this.quoteChar, this.escapeChar, this.strictQuotes, this.ignoreLeadingWhiteSpace, this.ignoreQuotations);
    }
}

