/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IFieldDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReferenceDescriptorWriter {
    public static final String TYPE_REFERENCES = "type_references";
    public static final String METHOD_REFERENCES = "method_references";
    public static final String FIELD_REFERENCES = "field_references";
    private static final Integer V_ILLEGAL = 22;
    private String fLocation = null;
    private Map<String, Map<String, Map<Integer, Map<Integer, Map<String, Set<IReferenceDescriptor>>>>>> fReferenceMap = null;
    private DocumentBuilder parser = null;
    private IComponentDescriptor alternate;

    public XmlReferenceDescriptorWriter(String location) {
        this.fLocation = location;
        try {
            this.parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError | ParserConfigurationException pce) {
            ApiPlugin.log(pce);
        }
    }

    public void writeReferences(IReferenceDescriptor[] references) {
        if (this.fLocation != null) {
            try {
                try {
                    File parent = new File(this.fLocation);
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.collateResults(references);
                    this.writeXML(parent);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    if (this.fReferenceMap != null) {
                        this.fReferenceMap.clear();
                        this.fReferenceMap = null;
                    }
                }
            }
            finally {
                if (this.fReferenceMap != null) {
                    this.fReferenceMap.clear();
                    this.fReferenceMap = null;
                }
            }
        }
    }

    private void collateResults(IReferenceDescriptor[] references) throws CoreException {
        if (this.fReferenceMap == null) {
            this.fReferenceMap = new HashMap<String, Map<String, Map<Integer, Map<Integer, Map<String, Set<IReferenceDescriptor>>>>>>();
        }
        IReferenceDescriptor[] iReferenceDescriptorArray = references;
        int n2 = references.length;
        int n3 = 0;
        while (n3 < n2) {
            IReferenceDescriptor reference = iReferenceDescriptorArray[n3];
            IComponentDescriptor rcomponent = reference.getReferencedComponent();
            String id = this.getId(rcomponent);
            Map rmap = this.fReferenceMap.computeIfAbsent(id, i -> new HashMap());
            IComponentDescriptor mcomponent = reference.getComponent();
            id = this.getId(mcomponent);
            Map mmap = rmap.computeIfAbsent(id, i -> new HashMap());
            Integer visibility = (reference.getReferenceFlags() & 1) > 0 ? V_ILLEGAL : Integer.valueOf(reference.getVisibility());
            Map vmap = mmap.computeIfAbsent(visibility, i -> new HashMap());
            int type = reference.getReferenceType();
            Map tmap = vmap.computeIfAbsent(type, t -> new HashMap());
            String tname = this.getText(reference.getReferencedMember());
            Set reflist = tmap.computeIfAbsent(tname, n -> new HashSet());
            reflist.add(reference);
            ++n3;
        }
    }

    private String getId(IComponentDescriptor component) {
        return component.getId() + " (" + component.getVersion() + ")";
    }

    private String getFormattedTypeName(String groupname) {
        if (TYPE_REFERENCES.equals(groupname)) {
            return "Types";
        }
        if (METHOD_REFERENCES.equals(groupname)) {
            return "Methods";
        }
        if (FIELD_REFERENCES.equals(groupname)) {
            return "Fields";
        }
        return "unknown references";
    }

    private String getRefTypeName(int type) {
        return switch (type) {
            case 1 -> TYPE_REFERENCES;
            case 3 -> METHOD_REFERENCES;
            case 2 -> FIELD_REFERENCES;
            default -> "unknown_reference_kinds";
        };
    }

    private void writeXML(File parent) throws CoreException, IOException {
        for (Map.Entry<String, Map<String, Map<Integer, Map<Integer, Map<String, Set<IReferenceDescriptor>>>>>> entry : this.fReferenceMap.entrySet()) {
            String referee = entry.getKey();
            File base = new File(parent, referee);
            if (!base.exists()) {
                base.mkdir();
            }
            for (Map.Entry<String, Map<Integer, Map<Integer, Map<String, Set<IReferenceDescriptor>>>>> entry2 : entry.getValue().entrySet()) {
                String id = entry2.getKey();
                File root = new File(base, id);
                if (!root.exists()) {
                    root.mkdir();
                }
                for (Map.Entry<Integer, Map<Integer, Map<String, Set<IReferenceDescriptor>>>> entry3 : entry2.getValue().entrySet()) {
                    Integer vis = entry3.getKey();
                    File location = new File(root, VisibilityModifiers.getVisibilityName(vis));
                    if (!location.exists()) {
                        location.mkdir();
                    }
                    for (Map.Entry<Integer, Map<String, Set<IReferenceDescriptor>>> entry4 : entry3.getValue().entrySet()) {
                        Integer type = entry4.getKey();
                        Map<String, Set<IReferenceDescriptor>> typemap = entry4.getValue();
                        this.writeGroup(id, referee, location, this.getRefTypeName(type), typemap, vis);
                    }
                }
            }
        }
    }

    private void writeGroup(String origin, String referee, File parent, String name, Map<String, Set<IReferenceDescriptor>> map, int visibility) throws CoreException, IOException {
        if (parent.exists()) {
            Iterator<Map.Entry<String, Set<IReferenceDescriptor>>> iterator;
            Throwable throwable;
            Document doc = null;
            Element root = null;
            int count = 0;
            File out = new File(parent, name + ".xml");
            if (out.exists()) {
                try {
                    try {
                        throwable = null;
                        iterator = null;
                        try (FileInputStream inputStream = new FileInputStream(out);){
                            doc = this.parser.parse(inputStream);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (doc == null) {
                        return;
                    }
                    root = doc.getDocumentElement();
                    String value = root.getAttribute("reference_count");
                    count = Integer.parseInt(value);
                }
                catch (SAXException se) {
                    se.printStackTrace();
                }
            } else {
                doc = Util.newDocument();
                root = doc.createElement("references");
                doc.appendChild(root);
                root.setAttribute("reference_visibility", Integer.toString(visibility));
                root.setAttribute("origin", origin);
                root.setAttribute("referee", referee);
                root.setAttribute("name", this.getFormattedTypeName(name));
                if (this.alternate != null) {
                    root.setAttribute("alternate", this.getId(this.alternate));
                }
            }
            if (doc == null || root == null) {
                return;
            }
            for (Map.Entry<String, Set<IReferenceDescriptor>> entry : map.entrySet()) {
                Set<IReferenceDescriptor> refs;
                String tname = entry.getKey();
                Element telement = this.findTypeElement(root, tname);
                if (telement == null) {
                    telement = doc.createElement("target");
                    telement.setAttribute("name", tname);
                    root.appendChild(telement);
                }
                if ((refs = entry.getValue()) == null) continue;
                Iterator<IReferenceDescriptor> iter2 = refs.iterator();
                while (iter2.hasNext()) {
                    IMemberDescriptor resolved;
                    ++count;
                    IReferenceDescriptor ref = iter2.next();
                    this.writeReference(doc, telement, ref);
                    if (iter2.hasNext() || (resolved = ref.getReferencedMember()) == null) continue;
                    this.addMemberDetails(telement, resolved);
                }
            }
            root.setAttribute("reference_count", Integer.toString(count));
            throwable = null;
            iterator = null;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), StandardCharsets.UTF_8));){
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    private void addMemberDetails(Element element, IMemberDescriptor member) {
        switch (member.getElementType()) {
            case 2: {
                element.setAttribute("type", ((IReferenceTypeDescriptor)member).getQualifiedName());
                break;
            }
            case 5: {
                IReferenceTypeDescriptor encl = member.getEnclosingType();
                element.setAttribute("type", encl.getQualifiedName());
                element.setAttribute("member", member.getName());
                break;
            }
            case 6: {
                IReferenceTypeDescriptor encl = member.getEnclosingType();
                element.setAttribute("type", encl.getQualifiedName());
                element.setAttribute("member", member.getName());
                element.setAttribute("signature", ((IMethodDescriptor)member).getSignature());
                break;
            }
        }
    }

    private Element findTypeElement(Element root, String tname) {
        if (tname == null) {
            return null;
        }
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("target");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (tname.equals(kelement.getAttribute("name"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private Element findKindElement(Element root, Integer kind) {
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("reference_kind");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (kind.toString().equals(kelement.getAttribute("kind"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private void writeReference(Document document, Element parent, IReferenceDescriptor reference) throws CoreException {
        Integer kind = reference.getReferenceKind();
        Element kelement = this.findKindElement(parent, kind);
        if (kelement == null) {
            kelement = document.createElement("reference_kind");
            kelement.setAttribute("reference_kind_name", Reference.getReferenceText(kind));
            kelement.setAttribute("kind", kind.toString());
            kelement.setAttribute("flags", Integer.toString(reference.getReferenceFlags()));
            parent.appendChild(kelement);
        }
        Element relement = document.createElement("reference");
        IMemberDescriptor member = reference.getMember();
        relement.setAttribute("origin", this.getText(member));
        Object[] messages = reference.getProblemMessages();
        if (messages != null) {
            relement.setAttribute("message_arguments", this.getText(messages));
        }
        this.addMemberDetails(relement, member);
        member = reference.getReferencedMember();
        if (member != null) {
            relement.setAttribute("linenumber", Integer.toString(reference.getLineNumber()));
            kelement.appendChild(relement);
        }
    }

    String getText(Object[] array) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < array.length) {
            buffer.append(array[i].toString());
            if (i < array.length - 1) {
                buffer.append(",");
            }
            ++i;
        }
        return buffer.toString();
    }

    private String getText(IMemberDescriptor member) throws CoreException {
        return switch (member.getElementType()) {
            case 2 -> Signatures.getQualifiedTypeSignature((IReferenceTypeDescriptor)member);
            case 6 -> Signatures.getQualifiedMethodSignature((IMethodDescriptor)member);
            case 5 -> Signatures.getQualifiedFieldSignature((IFieldDescriptor)member);
            default -> null;
        };
    }

    public void setAlternate(IComponentDescriptor other) {
        this.alternate = other;
    }
}

