/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.internal.core.text.DirtyFileProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class DirtyFileSearchParticipantServiceTracker
extends ServiceTracker<DirtyFileProvider, DirtyFileProvider> {
    private static final String PROPERTY_WEIGHT = "weight";

    public DirtyFileSearchParticipantServiceTracker(BundleContext context) throws InvalidSyntaxException {
        super(context, context.createFilter(MessageFormat.format("(&(objectClass={0}))", DirtyFileProvider.class.getCanonicalName())), null);
    }

    public DirtyFileProvider checkedGetService() {
        ServiceReference[] allRefs = this.getServiceReferences();
        if (allRefs != null && allRefs.length > 0) {
            List<ServiceReference> l = Arrays.asList(allRefs);
            Collections.sort(l, new Comparator<ServiceReference<DirtyFileProvider>>(){

                @Override
                public int compare(ServiceReference<DirtyFileProvider> o1, ServiceReference<DirtyFileProvider> o2) {
                    int o1Val;
                    Object o1Weight = o1.getProperty(DirtyFileSearchParticipantServiceTracker.PROPERTY_WEIGHT);
                    Object o2Weight = o2.getProperty(DirtyFileSearchParticipantServiceTracker.PROPERTY_WEIGHT);
                    int n = o1Weight == null ? 0 : (o1Val = o1Weight instanceof Integer ? (Integer)o1Weight : 0);
                    int o2Val = o2Weight == null ? 0 : (o2Weight instanceof Integer ? (Integer)o2Weight : 0);
                    return o2Val - o1Val;
                }
            });
            if (l.size() > 0) {
                return (DirtyFileProvider)this.getService(l.get(0));
            }
        }
        return new DirtyFileProvider(){

            @Override
            public Map<IFile, IDocument> dirtyFiles() {
                return Collections.EMPTY_MAP;
            }
        };
    }

    public void dispose() {
        this.close();
    }
}

