/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;

public class ConvertToStringFormatFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public ConvertToStringFormatFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation operation) {
        super(name, compilationUnit, operation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConvertToStringFormatFixCore createConvertToStringFormatFix(CompilationUnit compilationUnit, ASTNode node) {
        BodyDeclaration parentDecl = ASTResolving.findParentBodyDeclaration(node);
        if (!(parentDecl instanceof MethodDeclaration) && !(parentDecl instanceof Initializer)) {
            return null;
        }
        AST ast = node.getAST();
        ITypeBinding stringBinding = ast.resolveWellKnownType("java.lang.String");
        if (node instanceof Expression && !(node instanceof InfixExpression)) {
            node = node.getParent();
        }
        if (node instanceof VariableDeclarationFragment) {
            node = ((VariableDeclarationFragment)node).getInitializer();
        } else if (node instanceof Assignment) {
            node = ((Assignment)node).getRightHandSide();
        }
        InfixExpression oldInfixExpression = null;
        while (node instanceof InfixExpression) {
            InfixExpression curr = (InfixExpression)node;
            if (curr.resolveTypeBinding() != stringBinding || curr.getOperator() != InfixExpression.Operator.PLUS) break;
            oldInfixExpression = curr;
            node = node.getParent();
        }
        if (oldInfixExpression == null) {
            return null;
        }
        boolean is50OrHigher = JavaModelUtil.is50OrHigher(compilationUnit.getTypeRoot().getJavaProject());
        if (!is50OrHigher) {
            return null;
        }
        ArrayList<Expression> operands = new ArrayList<Expression>();
        ConvertToStringFormatFixCore.collectInfixPlusOperands((Expression)oldInfixExpression, operands);
        boolean foundNoneLiteralOperand = false;
        boolean seenTag = false;
        boolean seenNoTag = false;
        block3: for (Expression operand : operands) {
            if (!(operand instanceof StringLiteral)) {
                ITypeBinding binding;
                if (!is50OrHigher && (binding = operand.resolveTypeBinding()) == null) {
                    return null;
                }
                foundNoneLiteralOperand = true;
                continue;
            }
            ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
            try {
                NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
                if (nlsLine == null) continue;
                NLSElement[] nLSElementArray = nlsLine.getElements();
                int n = nLSElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NLSElement element = nLSElementArray[n2];
                    if (element.getPosition().getOffset() == operand.getStartPosition()) {
                        if (element.hasTag()) {
                            if (seenNoTag) {
                                return null;
                            }
                            seenTag = true;
                            continue block3;
                        }
                        if (seenTag) {
                            return null;
                        }
                        seenNoTag = true;
                        continue block3;
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        if (!foundNoneLiteralOperand) {
            return null;
        }
        return new ConvertToStringFormatFixCore(CorrectionMessages.QuickAssistProcessor_convert_to_string_format, compilationUnit, new ConvertToStringFormatProposalOperation(oldInfixExpression));
    }

    private static void collectInfixPlusOperands(Expression expression, List<Expression> collector) {
        if (expression instanceof InfixExpression && ((InfixExpression)expression).getOperator() == InfixExpression.Operator.PLUS) {
            InfixExpression infixExpression = (InfixExpression)expression;
            ConvertToStringFormatFixCore.collectInfixPlusOperands(infixExpression.getLeftOperand(), collector);
            ConvertToStringFormatFixCore.collectInfixPlusOperands(infixExpression.getRightOperand(), collector);
            List extendedOperands = infixExpression.extendedOperands();
            for (Expression expression2 : extendedOperands) {
                ConvertToStringFormatFixCore.collectInfixPlusOperands(expression2, collector);
            }
        } else {
            collector.add(expression);
        }
    }

    private static class ConvertToStringFormatProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private InfixExpression infixExpression;

        public ConvertToStringFormatProposalOperation(InfixExpression infixExpression) {
            this.infixExpression = infixExpression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            ICompilationUnit cu = cuRewrite.getCu();
            CompilationUnit root = cuRewrite.getRoot();
            String cuContents = cuRewrite.getCu().getBuffer().getContents();
            ArrayList<Expression> operands = new ArrayList<Expression>();
            ConvertToStringFormatFixCore.collectInfixPlusOperands((Expression)this.infixExpression, operands);
            ArrayList<String> formatArguments = new ArrayList<String>();
            StringBuilder formatString = new StringBuilder();
            int tagsCount = 0;
            for (Expression operand : operands) {
                if (operand instanceof StringLiteral) {
                    NLSLine nlsLine = NLSUtil.scanCurrentLine(cu, operand.getStartPosition());
                    if (nlsLine != null) {
                        NLSElement[] nLSElementArray = nlsLine.getElements();
                        int n = nLSElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            NLSElement element = nLSElementArray[n2];
                            if (element.getPosition().getOffset() == operand.getStartPosition() && element.hasTag()) {
                                ++tagsCount;
                            }
                            ++n2;
                        }
                    }
                    String value = ((StringLiteral)operand).getEscapedValue();
                    value = value.substring(1, value.length() - 1);
                    formatString.append(value);
                    continue;
                }
                ITypeBinding binding = operand.resolveTypeBinding();
                formatString.append("%").append(this.stringFormatConversion(binding));
                int origStart = root.getExtendedStartPosition((ASTNode)operand);
                int origLength = root.getExtendedLength((ASTNode)operand);
                String argument = cuContents.substring(origStart, origStart + origLength);
                formatArguments.add(argument);
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("String.format(");
            buffer.append("\"" + formatString.toString().replaceAll("\"", "\\\"") + "\"");
            for (String formatArgument : formatArguments) {
                buffer.append(", " + formatArgument);
            }
            buffer.append(")");
            if (tagsCount > 1) {
                ASTNodes.replaceAndRemoveNLSByCount(rewrite, (ASTNode)this.infixExpression, buffer.toString(), tagsCount - 1, null, cuRewrite);
            } else {
                MethodInvocation formatInvocation = (MethodInvocation)rewrite.createStringPlaceholder(buffer.toString(), 32);
                rewrite.replace((ASTNode)this.infixExpression, (ASTNode)formatInvocation, null);
            }
        }

        private char stringFormatConversion(ITypeBinding type) {
            switch (type.getName()) {
                case "int": 
                case "byte": 
                case "long": 
                case "short": {
                    return 'd';
                }
                case "double": 
                case "float": {
                    return 'f';
                }
                case "char": {
                    return 'c';
                }
            }
            return 's';
        }
    }
}

