/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.autocomplete;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.clauses.VersionedClause;
import aQute.bnd.osgi.BundleId;
import aQute.bnd.osgi.Descriptors;
import java.io.File;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class AddBundleCompletionProposal
extends WorkspaceJob
implements IJavaCompletionProposal {
    final BundleId bundle;
    final String displayString;
    final int relevance;
    final IInvocationContext context;
    final Project project;
    final String pathtype;
    final Map<String, Boolean> classes;

    public AddBundleCompletionProposal(BundleId bundle, Map<String, Boolean> classes, int relevance, IInvocationContext context, Project project, String pathtype) {
        super("Adding '" + bundle.getBsn() + "' to " + String.valueOf(project) + " " + pathtype);
        this.classes = classes;
        this.bundle = bundle;
        this.relevance = relevance;
        this.context = context;
        this.project = project;
        this.pathtype = pathtype;
        this.displayString = String.format("Add %s to %s (found %s)", bundle.getBsn(), pathtype, classes.keySet().stream().sorted().collect(Collectors.joining(", ")));
    }

    public void apply(IDocument document) {
        this.schedule();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.context.getSelectionOffset(), this.context.getSelectionLength());
    }

    public String getAdditionalProposalInfo() {
        return this.displayString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public Image getImage() {
        return Resources.getImage("/icons/bundle.png");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        try {
            Workspace ws = this.project.getWorkspace();
            IStatus status = (IStatus)ws.readLocked(() -> {
                BndEditModel model = new BndEditModel(this.project);
                model.load();
                VersionedClause vc = new VersionedClause(this.bundle.getBsn());
                model.addPath(vc, this.pathtype);
                model.saveChanges();
                this.refreshFile(this.project.getPropertiesFile());
                return Status.OK_STATUS;
            }, () -> ((IProgressMonitor)monitor).isCanceled());
            this.classes.entrySet().stream().filter(Map.Entry::getValue).forEach(pair -> {
                String fqn = (String)pair.getKey();
                String[] determine = (String[])Descriptors.determine((String)fqn).unwrap();
                assert (determine[0] != null) : "We must have found a package";
                try {
                    if (determine[1] == null) {
                        this.context.getCompilationUnit().createImport(fqn + ".*", null, monitor);
                    } else {
                        this.context.getCompilationUnit().createImport(fqn, null, monitor);
                    }
                }
                catch (JavaModelException jme) {
                    ILog.get().error("Couldn't add import for " + fqn, (Throwable)jme);
                }
            });
            return status;
        }
        catch (Exception e) {
            return new Status(4, "bndtools.core.services", "Failed to add bundle " + String.valueOf(this.bundle) + " to " + this.pathtype, (Throwable)e);
        }
    }

    private void refreshFile(File propertiesFile) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(IPath.fromOSString((String)propertiesFile.getAbsolutePath()));
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }
}

