/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExecutionEnvironment;
import org.eclipse.pde.internal.core.text.bundle.PDEManifestElement;
import org.eclipse.pde.internal.core.text.bundle.RequiredExecutionEnvironmentHeader;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.BundleInputContext;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ExecutionEnvironmentSection
extends TableSection {
    private TableViewer fEETable;
    private Action fRemoveAction;
    private Action fAddAction;

    public ExecutionEnvironmentSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.RequiredExecutionEnvironmentSection_add, PDEUIMessages.RequiredExecutionEnvironmentSection_remove, PDEUIMessages.RequiredExecutionEnvironmentSection_up, PDEUIMessages.RequiredExecutionEnvironmentSection_down});
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.RequiredExecutionEnvironmentSection_title);
        if (this.isFragment()) {
            section.setDescription(PDEUIMessages.RequiredExecutionEnvironmentSection_fragmentDesc);
        } else {
            section.setDescription(PDEUIMessages.RequiredExecutionEnvironmentSection_pluginDesc);
        }
        section.setLayout((Layout)FormLayoutFactory.createClearTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setEditable(this.isEditable());
        this.createViewerPartControl(container, 65538, 2, toolkit);
        this.fEETable = tablePart.getTableViewer();
        this.fEETable.setContentProvider((IContentProvider)new ContentProvider());
        this.fEETable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        Hyperlink link = toolkit.createHyperlink(container, PDEUIMessages.BuildExecutionEnvironmentSection_configure, 0);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                SWTFactory.showPreferencePage(PDEPlugin.getActiveWorkbenchShell(), "org.eclipse.jdt.debug.ui.jreProfiles", null);
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        link.setLayoutData((Object)gd);
        final IProject project = this.getPage().getPDEEditor().getCommonProject();
        try {
            if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                link = toolkit.createHyperlink(container, PDEUIMessages.ExecutionEnvironmentSection_updateClasspath, 0);
                link.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            ExecutionEnvironmentSection.this.getPage().getEditor().doSave(null);
                            IPluginModelBase model = PluginRegistry.findModel((IProject)project);
                            if (model != null) {
                                ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
                                if (PDEPlugin.getWorkspace().isAutoBuilding()) {
                                    ExecutionEnvironmentSection.this.doFullBuild(project);
                                }
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                });
                gd = new GridData();
                gd.horizontalSpan = 2;
                link.setLayoutData((Object)gd);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.makeActions();
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            this.fEETable.setInput((Object)model);
            model.addModelChangedListener((IModelChangedListener)this);
        }
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        IBundleModel model = this.getBundleModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
    }

    public void refresh() {
        this.fEETable.refresh();
        this.updateButtons();
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
            }
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fAddAction);
        if (!this.fEETable.getStructuredSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiredExecutionEnvironmentSection_add){

            public void run() {
                ExecutionEnvironmentSection.this.handleAdd();
            }
        };
        this.fAddAction.setEnabled(this.isEditable());
        this.fRemoveAction = new Action(PDEUIMessages.NewManifestEditor_LibrarySection_remove){

            public void run() {
                ExecutionEnvironmentSection.this.handleRemove();
            }
        };
        this.fRemoveAction.setEnabled(this.isEditable());
    }

    private void updateButtons() {
        Table table = this.fEETable.getTable();
        int count = table.getItemCount();
        boolean canMoveUp = count > 0 && table.getSelection().length == 1 && table.getSelectionIndex() > 0;
        boolean canMoveDown = count > 0 && table.getSelection().length == 1 && table.getSelectionIndex() < count - 1;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable() && table.getSelection().length > 0);
        tablePart.setButtonEnabled(2, this.isEditable() && canMoveUp);
        tablePart.setButtonEnabled(3, this.isEditable() && canMoveDown);
    }

    private void handleDown() {
        int selection = this.fEETable.getTable().getSelectionIndex();
        this.swap(selection, selection + 1);
    }

    private void handleUp() {
        int selection = this.fEETable.getTable().getSelectionIndex();
        this.swap(selection, selection - 1);
    }

    public void swap(int index1, int index2) {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        header.swap(index1, index2);
    }

    private void handleRemove() {
        IStructuredSelection ssel = this.fEETable.getStructuredSelection();
        if (!ssel.isEmpty()) {
            for (Object object : ssel) {
                if (!(object instanceof ExecutionEnvironment)) continue;
                this.getHeader().removeExecutionEnvironment((ExecutionEnvironment)object);
            }
        }
    }

    private void handleAdd() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new EELabelProvider());
        dialog.setElements(this.getEnvironments());
        dialog.setAllowDuplicates(false);
        dialog.setMultipleSelection(true);
        dialog.setTitle(PDEUIMessages.RequiredExecutionEnvironmentSection_dialog_title);
        dialog.setMessage(PDEUIMessages.RequiredExecutionEnvironmentSection_dialogMessage);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.execution_environment_selection");
        if (dialog.open() == 0) {
            this.addExecutionEnvironments(dialog.getResult());
        }
    }

    private void addExecutionEnvironments(Object[] result) {
        block9: {
            RequiredExecutionEnvironmentHeader header;
            block5: {
                header = this.getHeader();
                if (header != null) break block5;
                StringBuilder buffer = new StringBuilder();
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        String id;
                        block7: {
                            Object resultObject;
                            block6: {
                                resultObject = objectArray[n2];
                                id = null;
                                if (!(resultObject instanceof IExecutionEnvironment)) break block6;
                                id = ((IExecutionEnvironment)resultObject).getId();
                                break block7;
                            }
                            if (!(resultObject instanceof ExecutionEnvironment)) break block8;
                            id = ((ExecutionEnvironment)resultObject).getName();
                        }
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(this.getLineDelimiter());
                            buffer.append(" ");
                        }
                        buffer.append(id);
                    }
                    ++n2;
                }
                this.getBundle().setHeader("Bundle-RequiredExecutionEnvironment", buffer.toString());
                break block9;
            }
            RequiredExecutionEnvironmentHeader ee = header;
            ee.addExecutionEnvironments(result);
        }
    }

    private String getLineDelimiter() {
        BundleInputContext inputContext = this.getBundleContext();
        if (inputContext != null) {
            return inputContext.getLineDelimiter();
        }
        return TextUtil.getDefaultLineDelimiter();
    }

    private Object[] getEnvironments() {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        Object[] envs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        if (header == null) {
            return envs;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < envs.length) {
            if (!header.hasExecutionEnvironment((IExecutionEnvironment)envs[i])) {
                list.add(envs[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        } else if (e.getChangeType() == 2) {
            Object[] objects;
            Object[] objectArray = objects = e.getChangedObjects();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                Table table = this.fEETable.getTable();
                if (object instanceof ExecutionEnvironment) {
                    int index = table.getSelectionIndex();
                    this.fEETable.remove(object);
                    if (this.canSelect()) {
                        table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
                    }
                }
                ++n2;
            }
            this.updateButtons();
        } else if (e.getChangeType() == 1) {
            Object[] objects = e.getChangedObjects();
            if (objects.length > 0) {
                this.fEETable.refresh();
                this.fEETable.setSelection((ISelection)new StructuredSelection(objects[objects.length - 1]));
            }
            this.updateButtons();
        } else if ("Bundle-RequiredExecutionEnvironment".equals(e.getChangedProperty())) {
            this.refresh();
            Object lastElement = this.fEETable.getElementAt(this.fEETable.getTable().getItemCount() - 1);
            if (lastElement != null) {
                this.fEETable.setSelection((ISelection)new StructuredSelection(lastElement));
            }
        }
    }

    private BundleInputContext getBundleContext() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        return (BundleInputContext)manager.findContext("bundle-context");
    }

    private IBundle getBundle() {
        IBundleModel model = this.getBundleModel();
        return model == null ? null : model.getBundle();
    }

    private IBundleModel getBundleModel() {
        BundleInputContext context = this.getBundleContext();
        return context == null ? null : context.getModel();
    }

    protected RequiredExecutionEnvironmentHeader getHeader() {
        IBundle bundle = this.getBundle();
        if (bundle == null) {
            return null;
        }
        IManifestHeader header = bundle.getManifestHeader("Bundle-RequiredExecutionEnvironment");
        if (header instanceof RequiredExecutionEnvironmentHeader) {
            return (RequiredExecutionEnvironmentHeader)header;
        }
        return null;
    }

    protected boolean isFragment() {
        InputContextManager manager = this.getPage().getPDEEditor().getContextManager();
        IBaseModel iBaseModel = manager.getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)iBaseModel;
            return model.isFragmentModel();
        }
        return false;
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ExecutionEnvironment) {
                String env = ((ExecutionEnvironment)object).getName();
                if (header == null || !header.hasElement(env)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        if (this.getPage().getModel().isEditable()) {
            this.updateButtons();
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        this.addExecutionEnvironments(objects);
    }

    private void doFullBuild(final IProject project) {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    project.build(6, "org.eclipse.jdt.core.javabuilder", null, monitor);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    @Override
    protected boolean isDragAndDropEnabled() {
        return true;
    }

    @Override
    public boolean canDragMove(Object[] sourceObjects) {
        return this.validateDragMoveSanity(sourceObjects);
    }

    @Override
    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            return false;
        }
        ExecutionEnvironment sourceEEObject = (ExecutionEnvironment)sourceObjects[0];
        ExecutionEnvironment targetEEObject = (ExecutionEnvironment)targetObject;
        if (!this.validateDropMoveModel(sourceEEObject, targetEEObject)) {
            return false;
        }
        if (targetLocation == 1) {
            RequiredExecutionEnvironmentHeader header = this.getHeader();
            if (header == null) {
                return false;
            }
            PDEManifestElement previousElement = header.getPreviousElement((PDEManifestElement)targetEEObject);
            return !sourceEEObject.equals(previousElement);
        }
        if (targetLocation == 2) {
            RequiredExecutionEnvironmentHeader header = this.getHeader();
            if (header == null) {
                return false;
            }
            PDEManifestElement nextElement = header.getNextElement((PDEManifestElement)targetEEObject);
            return !sourceEEObject.equals(nextElement);
        }
        if (targetLocation == 3) {
            return false;
        }
        return false;
    }

    private boolean validateDropMoveModel(ExecutionEnvironment sourceEEObject, ExecutionEnvironment targetEEObject) {
        IBundleModel targetModel;
        IBundleModel sourceModel = sourceEEObject.getModel();
        return sourceModel.equals(targetModel = targetEEObject.getModel());
    }

    private boolean validateDropMoveSanity(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof ExecutionEnvironment)) {
            return false;
        }
        return this.validateDragMoveSanity(sourceObjects);
    }

    @Override
    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        ExecutionEnvironment sourceEEObject = (ExecutionEnvironment)sourceObjects[0];
        ExecutionEnvironment targetEEObject = (ExecutionEnvironment)targetObject;
        if (targetLocation == 1) {
            RequiredExecutionEnvironmentHeader header = this.getHeader();
            if (header == null) {
                return;
            }
            int index = header.indexOf((PDEManifestElement)targetEEObject);
            if (index == -1) {
                return;
            }
            header.addExecutionEnvironment(sourceEEObject, index);
            return;
        }
        if (targetLocation == 2) {
            RequiredExecutionEnvironmentHeader header = this.getHeader();
            if (header == null) {
                return;
            }
            int index = header.indexOf((PDEManifestElement)targetEEObject);
            if (index == -1) {
                return;
            }
            header.addExecutionEnvironment(sourceEEObject, index + 1);
            return;
        }
    }

    @Override
    public void doDragRemove(Object[] sourceObjects) {
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return;
        }
        ExecutionEnvironment environment = (ExecutionEnvironment)sourceObjects[0];
        RequiredExecutionEnvironmentHeader header = this.getHeader();
        if (header == null) {
            return;
        }
        this.doSelect(false);
        header.removeExecutionEnvironmentUnique(environment);
        this.doSelect(true);
    }

    private boolean validateDragMoveSanity(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        return sourceObjects[0] instanceof ExecutionEnvironment;
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IBundleModel model;
            IBundle bundle;
            IManifestHeader header;
            if (inputElement instanceof IBundleModel && (header = (bundle = (model = (IBundleModel)inputElement).getBundle()).getManifestHeader("Bundle-RequiredExecutionEnvironment")) instanceof RequiredExecutionEnvironmentHeader) {
                return ((RequiredExecutionEnvironmentHeader)header).getEnvironments();
            }
            return new Object[0];
        }
    }

    class EELabelProvider
    extends LabelProvider {
        private final Image fImage = PDEPluginImages.DESC_JAVA_LIB_OBJ.createImage();

        public Image getImage(Object element) {
            return this.fImage;
        }

        public String getText(Object element) {
            if (element instanceof IExecutionEnvironment) {
                return ((IExecutionEnvironment)element).getId();
            }
            return super.getText(element);
        }

        public void dispose() {
            if (this.fImage != null) {
                this.fImage.dispose();
            }
            super.dispose();
        }
    }
}

