/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.P2Utils;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;

public class LaunchConfigurationHelper {
    private static final String PROP_OSGI_FRAMEWORK = "osgi.framework";
    private static final String PROP_OSGI_EXTENSIONS = "osgi.framework.extensions";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private static final String PROP_P2_DATA_AREA = "eclipse.p2.data.area";
    private static final String PROP_PRODUCT = "eclipse.product";
    private static final String PROP_APPLICATION = "eclipse.application";
    private static final String DEFAULT_PROFILE_NAME = "SelfHostingProfile";
    private static final String DEFAULT_P2_DIRECTORY = ".p2";

    public static void synchronizeManifests(ILaunchConfiguration config, File configDir) {
        try {
            String programArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            if (programArgs.contains("-clean")) {
                return;
            }
        }
        catch (CoreException programArgs) {
            // empty catch block
        }
        File dir = new File(configDir, "org.eclipse.osgi/manifests");
        if (dir.exists() && dir.isDirectory()) {
            PDECore.getDefault().getJavaElementChangeListener().synchronizeManifests(dir);
        }
    }

    public static File getConfigurationArea(ILaunchConfiguration config) {
        File dir = LaunchConfigurationHelper.getConfigurationLocation(config);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getConfigurationLocation(ILaunchConfiguration config) {
        String configName = config.getName();
        configName = configName.replace('#', 'h');
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString(), configName);
        try {
            String userPath;
            if (!config.getAttribute("useDefaultConfigArea", true) && (userPath = config.getAttribute("configLocation", null)) != null) {
                userPath = LaunchConfigurationHelper.getSubstitutedString(userPath);
                dir = new File(userPath).getAbsoluteFile();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return dir;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static Properties createConfigIniFile(ILaunchConfiguration configuration, String productID, Map<String, List<IPluginModelBase>> bundles, Map<IPluginModelBase, String> bundlesWithStartLevels, File configurationDirectory) throws CoreException {
        return LaunchConfigurationHelper.createConfigIniFile(configuration, productID, bundles, null, bundlesWithStartLevels, configurationDirectory);
    }

    public static Properties createConfigIniFile(ILaunchConfiguration configuration, String productID, Map<String, List<IPluginModelBase>> bundles, Map<IFeature, Boolean> features, Map<IPluginModelBase, String> bundlesWithStartLevels, File configurationDirectory) throws CoreException {
        String osgiBundles;
        Properties properties = null;
        if (configuration.getAttribute("useDefaultConfig", true)) {
            String appID = configuration.getAttribute("application", null);
            properties = TargetPlatformHelper.getConfigIniProperties();
            if (properties == null) {
                properties = new Properties();
            } else if (productID != null && !productID.equals(properties.get(PROP_PRODUCT)) || appID != null && !appID.equals(properties.get(PROP_APPLICATION))) {
                properties.clear();
            }
            String bundleList = properties.getProperty(PROP_OSGI_BUNDLES);
            if (bundleList != null) {
                boolean autoStart = configuration.getAttribute("default_auto_start", false);
                properties.setProperty(PROP_OSGI_BUNDLES, LaunchConfigurationHelper.computeOSGiBundles(TargetPlatformHelper.stripPathInformation((String)bundleList), bundles, bundlesWithStartLevels, autoStart));
            }
        } else {
            String templateLoc = configuration.getAttribute("templateConfig", null);
            if (templateLoc != null && (osgiBundles = (properties = LaunchConfigurationHelper.loadFromTemplate(LaunchConfigurationHelper.getSubstitutedString(templateLoc))).getProperty(PROP_OSGI_BUNDLES)) != null) {
                properties.setProperty(PROP_OSGI_BUNDLES, TargetPlatformHelper.stripPathInformation((String)osgiBundles));
            }
        }
        boolean autostart = configuration.getAttribute("default_auto_start", false);
        if (properties != null) {
            LaunchConfigurationHelper.addRequiredProperties(properties, productID, bundles, bundlesWithStartLevels, autostart);
        } else {
            properties = new Properties();
        }
        if (!configurationDirectory.exists()) {
            configurationDirectory.mkdirs();
        }
        osgiBundles = properties.getProperty(PROP_OSGI_BUNDLES);
        int start = configuration.getAttribute("default_start_level", 4);
        properties.put("osgi.bundles.defaultStartLevel", Integer.toString(start));
        if (osgiBundles != null && osgiBundles.contains("org.eclipse.equinox.simpleconfigurator") && bundles.containsKey("org.eclipse.equinox.simpleconfigurator")) {
            URL bundlesTxt = null;
            boolean usedefault = configuration.getAttribute("default", true);
            bundlesTxt = usedefault ? P2Utils.writeBundlesTxt(bundlesWithStartLevels, (int)start, (boolean)autostart, (File)configurationDirectory, (String)osgiBundles) : P2Utils.writeBundlesTxt(bundlesWithStartLevels, (int)start, (boolean)autostart, (File)configurationDirectory, null);
            if (bundlesTxt != null) {
                properties.setProperty("org.eclipse.equinox.simpleconfigurator.configUrl", bundlesTxt.toString());
                if (bundles.get("org.eclipse.update.configurator") != null) {
                    properties.setProperty("org.eclipse.update.reconcile", "false");
                }
            }
            properties.setProperty(PROP_P2_DATA_AREA, "@config.dir/".concat(DEFAULT_P2_DIRECTORY));
            if (configuration.getAttribute("generateProfile", false)) {
                String profileID = DEFAULT_PROFILE_NAME;
                File p2DataArea = new File(configurationDirectory, DEFAULT_P2_DIRECTORY);
                if (!configuration.getAttribute("restart", false) || !P2Utils.profileExists((String)profileID, (File)p2DataArea)) {
                    P2Utils.createProfile((String)profileID, (File)p2DataArea, bundles.values(), features);
                }
                properties.setProperty("eclipse.p2.profile", profileID);
            }
        }
        LaunchConfigurationHelper.setBundleLocations(bundles, properties, autostart);
        LaunchConfigurationHelper.save(new File(configurationDirectory, "config.ini"), properties);
        return properties;
    }

    private static void addRequiredProperties(Properties properties, String productID, Map<String, List<IPluginModelBase>> bundles, Map<IPluginModelBase, String> bundlesWithStartLevels, boolean autoStart) {
        if (!properties.containsKey("osgi.install.area")) {
            properties.setProperty("osgi.install.area", "file:" + TargetPlatform.getLocation());
        }
        if (!properties.containsKey("osgi.configuration.cascaded")) {
            properties.setProperty("osgi.configuration.cascaded", "false");
        }
        if (!properties.containsKey(PROP_OSGI_FRAMEWORK)) {
            properties.setProperty(PROP_OSGI_FRAMEWORK, "org.eclipse.osgi");
        }
        if (!properties.containsKey("osgi.splashPath") && productID != null) {
            LaunchConfigurationHelper.addSplashLocation(properties, productID, bundles);
        }
        if (properties.containsKey("osgi.splashPath")) {
            LaunchConfigurationHelper.resolveLocationPath(properties.getProperty("osgi.splashPath"), properties, bundles);
        }
        if (!properties.containsKey(PROP_OSGI_BUNDLES)) {
            properties.setProperty(PROP_OSGI_BUNDLES, LaunchConfigurationHelper.computeOSGiBundles(TargetPlatform.getBundleList(), bundles, bundlesWithStartLevels, autoStart));
        }
        if (!properties.containsKey("osgi.bundles.defaultStartLevel")) {
            properties.setProperty("osgi.bundles.defaultStartLevel", "4");
        }
    }

    private static String computeOSGiBundles(String initialBundleList, Map<String, List<IPluginModelBase>> bundles, Map<IPluginModelBase, String> bundlesWithStartLevels, boolean defaultAuto) {
        if (bundles.get("org.eclipse.equinox.simpleconfigurator") != null) {
            return "org.eclipse.equinox.simpleconfigurator@1:start";
        }
        HashMap<IPluginModelBase, String> allBundles = new HashMap<IPluginModelBase, String>(bundlesWithStartLevels);
        allBundles.keySet().removeIf(model -> "org.eclipse.osgi".equals(model.getPluginBase().getId()));
        StringTokenizer tokenizer = new StringTokenizer(initialBundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String id = index != -1 ? token.substring(0, index) : token;
            IPluginModelBase model2 = LaunchConfigurationHelper.getLatestModel(id, bundles);
            if (model2 == null) continue;
            String startInfo2 = index + 1 < token.length() ? token.substring(index + 1) : (String)allBundles.get(model2);
            allBundles.put(model2, startInfo2 != null ? startInfo2 : "");
        }
        StringJoiner osgiBundles = new StringJoiner(",");
        allBundles.forEach((bundle, startInfo) -> {
            String bundleURL = LaunchConfigurationHelper.getBundleURL(bundle, true);
            String startData = LaunchConfigurationHelper.getStartData(startInfo, defaultAuto);
            osgiBundles.add(bundleURL + startData);
        });
        return osgiBundles.toString();
    }

    private static Properties loadFromTemplate(String templateLoc) throws CoreException {
        Properties properties;
        block12: {
            properties = new Properties();
            File templateFile = new File(templateLoc);
            if (templateFile.exists() && templateFile.isFile()) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (FileInputStream stream = new FileInputStream(templateFile);){
                        properties.load(stream);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    String message = e.getMessage();
                    if (message == null) break block12;
                    throw new CoreException(Status.error((String)message, (Throwable)e));
                }
            }
        }
        return properties;
    }

    private static void addSplashLocation(Properties properties, String productID, Map<String, List<IPluginModelBase>> map) {
        String targetSplash;
        Properties targetConfig = TargetPlatformHelper.getConfigIniProperties();
        String targetProduct = targetConfig == null ? null : targetConfig.getProperty(PROP_PRODUCT);
        String string = targetSplash = targetConfig == null ? null : targetConfig.getProperty("osgi.splashPath");
        if (!productID.equals(targetProduct) || targetSplash == null) {
            BundleDescription desc;
            ArrayList<String> locations = new ArrayList<String>();
            String plugin = LaunchConfigurationHelper.getContributingPlugin(productID);
            locations.add(plugin);
            IPluginModelBase model = LaunchConfigurationHelper.getLatestModel(plugin, map);
            if (model != null && (desc = model.getBundleDescription()) != null) {
                BundleDescription[] fragments;
                BundleDescription[] bundleDescriptionArray = fragments = desc.getFragments();
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    BundleDescription fragment = bundleDescriptionArray[n2];
                    locations.add(fragment.getSymbolicName());
                    ++n2;
                }
            }
            LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
        } else {
            LaunchConfigurationHelper.resolveLocationPath(targetSplash, properties, map);
        }
    }

    private static void resolveLocationPath(String splashPath, Properties properties, Map<String, List<IPluginModelBase>> map) {
        ArrayList<String> locations = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(splashPath, ",");
        while (tok.hasMoreTokens()) {
            locations.add(tok.nextToken());
        }
        LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
    }

    private static void resolveLocationPath(ArrayList<String> locations, Properties properties, Map<String, List<IPluginModelBase>> map) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < locations.size()) {
            String url;
            String location = locations.get(i);
            if (location.startsWith("platform:/base/plugins/")) {
                location = location.replaceFirst("platform:/base/plugins/", "");
            }
            if ((url = LaunchConfigurationHelper.getBundleURL(location, map, false)) != null) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(url);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            properties.setProperty("osgi.splashPath", buffer.toString());
        }
    }

    public static String getBundleURL(String id, Map<String, List<IPluginModelBase>> pluginMap, boolean includeReference) {
        IPluginModelBase model = LaunchConfigurationHelper.getLatestModel(id, pluginMap);
        return LaunchConfigurationHelper.getBundleURL(model, includeReference);
    }

    public static IPluginModelBase getLatestModel(String id, Map<String, List<IPluginModelBase>> plugins) {
        List models = plugins.getOrDefault(id.trim(), Collections.emptyList());
        return models.stream().max(BundleLauncherHelper.VERSION).orElse(null);
    }

    public static String getBundleURL(IPluginModelBase model, boolean includeReference) {
        if (model == null || model.getInstallLocation() == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (includeReference) {
            buf.append("reference:");
        }
        buf.append("file:");
        buf.append(IPath.fromOSString((String)model.getInstallLocation()).removeTrailingSeparator().toString());
        return buf.toString();
    }

    private static void setBundleLocations(Map<String, List<IPluginModelBase>> map, Properties properties, boolean defaultAuto) {
        String bundles;
        String extensions;
        String url;
        String framework = properties.getProperty(PROP_OSGI_FRAMEWORK);
        if (framework != null && (url = LaunchConfigurationHelper.getBundleURL(framework = TargetPlatformHelper.stripPathInformation((String)framework), map, false)) != null) {
            properties.setProperty(PROP_OSGI_FRAMEWORK, url);
        }
        if ((extensions = properties.getProperty(PROP_OSGI_EXTENSIONS)) != null) {
            String[] extensionsArray;
            StringBuilder buffer = new StringBuilder();
            String[] stringArray = extensionsArray = extensions.split(",");
            int n = extensionsArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                String bundle = TargetPlatformHelper.stripPathInformation((String)element);
                String url2 = LaunchConfigurationHelper.getBundleURL(bundle, map, true);
                if (url2 != null) {
                    if (buffer.length() > 0) {
                        buffer.append(',');
                    }
                    buffer.append(url2);
                }
                ++n2;
            }
            if (buffer.length() > 0) {
                properties.setProperty(PROP_OSGI_EXTENSIONS, buffer.toString());
            }
        }
        if ((bundles = properties.getProperty(PROP_OSGI_BUNDLES)) != null) {
            StringBuilder buffer = new StringBuilder();
            StringTokenizer tokenizer = new StringTokenizer(bundles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                if (token.startsWith("reference")) {
                    if (buffer.length() > 0) {
                        buffer.append(',');
                    }
                    buffer.append(token);
                    continue;
                }
                String url3 = LaunchConfigurationHelper.getBundleURL(token, map, true);
                int i = -1;
                if (url3 == null) {
                    i = token.indexOf(64);
                    if (i != -1) {
                        url3 = LaunchConfigurationHelper.getBundleURL(token.substring(0, i), map, true);
                    }
                    if (url3 == null && (i = token.indexOf(58)) != -1) {
                        url3 = LaunchConfigurationHelper.getBundleURL(token.substring(0, i), map, true);
                    }
                }
                if (url3 == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(url3);
                if (i == -1) continue;
                String slinfo = token.substring(i + 1);
                buffer.append(LaunchConfigurationHelper.getStartData(slinfo, defaultAuto));
            }
            properties.setProperty(PROP_OSGI_BUNDLES, buffer.toString());
        }
    }

    public static String getStartData(String startData, boolean defaultAuto) {
        StringBuilder buffer = new StringBuilder();
        int index = startData.indexOf(58);
        String level = index > 0 ? startData.substring(0, index) : "default";
        String auto = startData;
        if (!startData.equals("start")) {
            String string = auto = index >= 0 && index < startData.length() - 1 ? startData.substring(index + 1) : "default";
        }
        if ("default".equals(auto)) {
            auto = Boolean.toString(defaultAuto);
        }
        if (!level.equals("default") || "true".equals(auto) || "start".equals(auto)) {
            buffer.append("@");
        }
        if (!level.equals("default")) {
            buffer.append(level);
            if ("start".equals(auto) || "true".equals(auto)) {
                buffer.append(":");
            }
        }
        if ("start".equals(auto) || "true".equals(auto)) {
            buffer.append("start");
        }
        return buffer.toString();
    }

    public static void save(File file, Properties properties) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                properties.store(stream, "Configuration File");
                stream.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public static String getContributingPlugin(String productID) {
        if (productID == null) {
            return null;
        }
        int index = productID.lastIndexOf(46);
        return index == -1 ? productID : productID.substring(0, index);
    }

    public static String getProductID(ILaunchConfiguration configuration) throws CoreException {
        IExtension[] extensions;
        if (configuration.getAttribute("useProduct", false)) {
            return configuration.getAttribute("product", null);
        }
        String appID = configuration.getAttribute("application", TargetPlatform.getDefaultApplication());
        IExtension[] iExtensionArray = extensions = PDECore.getDefault().getExtensionsRegistry().findExtensions("org.eclipse.core.runtime.products", true);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            IExtension extension = iExtensionArray[n2];
            String id = extension.getUniqueIdentifier();
            if (id != null && (children = extension.getConfigurationElements()).length == 1 && "product".equals(children[0].getName()) && appID.equals(children[0].getAttribute("application"))) {
                return id;
            }
            ++n2;
        }
        return null;
    }
}

