/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.CopyRefactoring;
import org.eclipse.ltk.internal.core.refactoring.resource.CopyProjectProcessor;
import org.eclipse.ltk.internal.ui.refactoring.actions.AbstractResourcesHandler;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyProjectHandler
extends AbstractResourcesHandler {
    private static final String LTK_COPY_PROJECT_COMMAND_NEWNAME_KEY = "org.eclipse.ltk.ui.refactoring.commands.copyProject.newName.parameter.key";
    private static final String LTK_COPY_PROJECT_COMMAND_NEWLOCATION_KEY = "org.eclipse.ltk.ui.refactoring.commands.copyProject.newLocation.parameter.key";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object newNameValue = HandlerUtil.getVariable((ExecutionEvent)event, (String)LTK_COPY_PROJECT_COMMAND_NEWNAME_KEY);
        Object newLocationValue = HandlerUtil.getVariable((ExecutionEvent)event, (String)LTK_COPY_PROJECT_COMMAND_NEWLOCATION_KEY);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String newName = null;
        if (newNameValue instanceof String) {
            newName = (String)newNameValue;
        }
        IPath newLocation = null;
        if (newLocationValue instanceof IPath) {
            newLocation = (IPath)newLocationValue;
        }
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            List<IProject> resources = Arrays.stream(this.getSelectedResources(selection)).filter(IProject.class::isInstance).map(IProject.class::cast).toList();
            if (resources.size() == 1) {
                CopyRefactoring copyRefactoring = new CopyRefactoring((CopyProcessor)new CopyProjectProcessor(resources.get(0), newName, newLocation));
                try {
                    CreateChangeOperation create = new CreateChangeOperation(new CheckConditionsOperation((Refactoring)copyRefactoring, 4), 4);
                    PerformChangeOperation perform = new PerformChangeOperation(create);
                    perform.setUndoManager(RefactoringCore.getUndoManager(), copyRefactoring.getName());
                    perform.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

