/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.dnd;

import aQute.bnd.build.WorkspaceRepository;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.pde.bnd.ui.dnd.GAVDropTargetListener;
import org.eclipse.swt.custom.StyledText;
import org.osgi.resource.Resource;

public class BndDropTargetListener
extends GAVDropTargetListener {
    private static final IPreferencesService prefsService = Platform.getPreferencesService();

    public BndDropTargetListener(StyledText styledText) {
        super(styledText);
    }

    @Override
    void format(GAVDropTargetListener.FormatEvent formatEvent) {
        if (formatEvent.isNoVersion()) {
            Syntax syntax = Syntax.BND_VERSION_LATEST;
            if (formatEvent.getRepositoryPlugin() instanceof WorkspaceRepository) {
                syntax = Syntax.BND_VERSION_SNAPSHOT;
            }
            this.format(formatEvent.getResource(), formatEvent.useAlternateSyntax() ? Syntax.BND_NO_VERSION : syntax, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), BndDropTargetListener.indent(this.isTabs(), this.getSize()));
        } else {
            this.format(formatEvent.getResource(), Syntax.BND, formatEvent.getLineAtInsertionPoint(), formatEvent.getIndentPrefix(), BndDropTargetListener.indent(this.isTabs(), this.getSize()));
        }
    }

    @Override
    boolean hasAlternateSyntax() {
        return true;
    }

    int getSize() {
        if (this.isTabs()) {
            return 1;
        }
        return prefsService.getInt("org.eclipse.ui.editors.prefs", "tabWidth", 4, null);
    }

    boolean isTabs() {
        return !prefsService.getBoolean("org.eclipse.ui.editors.prefs", "spacesForTabs", false, null);
    }

    private void format(Resource resource, Syntax syntax, String lineAtInsertionPoint, String indentPrefix, String indent) {
        ResourceUtils.IdentityCapability ic = ResourceUtils.getIdentityCapability((Resource)resource);
        BridgeRepository.InfoCapability info = BridgeRepository.getInfo((Resource)resource);
        String identity = "";
        String version = "";
        if (ic == null) {
            if (info == null) {
                return;
            }
            identity = info.name();
            version = info.version().toString();
        } else {
            identity = ic.osgi_identity();
            version = ic.version().toString();
        }
        if (lineAtInsertionPoint.trim().startsWith("-")) {
            indentPrefix = (String)indentPrefix + indent;
        }
        boolean lineHasContinuation = lineAtInsertionPoint.endsWith("\\");
        StringBuilder sb = new StringBuilder();
        if (!lineHasContinuation) {
            sb.append(",\\");
        }
        sb.append("\n").append((String)(((String)indentPrefix).isEmpty() ? indent : indentPrefix)).append(identity);
        switch (syntax) {
            case BND: {
                sb.append(";version='").append(version).append("'");
                break;
            }
            case BND_NO_VERSION: {
                break;
            }
            case BND_VERSION_LATEST: {
                sb.append(";version=latest");
                break;
            }
            case BND_VERSION_SNAPSHOT: {
                sb.append(";version=snapshot");
            }
        }
        if (lineHasContinuation) {
            sb.append(",\\");
        }
        this.getStyledText().insert(sb.toString());
    }

    static enum Syntax {
        BND,
        BND_NO_VERSION,
        BND_VERSION_LATEST,
        BND_VERSION_SNAPSHOT;

    }
}

